/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.jsa.safe.bugdetecter.preferences;

import java.io.File;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.preference.IPreferenceStore;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.web.jsa.JsaPlugin;
import org.tizen.web.jsa.safe.bugdetecter.preferences.OSChecker;
import org.tizen.web.jsa.safe.bugdetecter.util.IOUtil;

public class Settings {
    public static final String SAFE_LOCATION_PATH = "SAFE_LOCATION_PATH";
    public static final String SAFE_OPTS_ARGUMENTS = "SAFE_OPTS_ARGUMENTS";
    public static final String WIDL_DATABASE_LOCATION_PATH = "WIDL_DATABASE_LOCATION_PATH";
    public static final String JAVA_OPTS = "JAVA_OPTS";
    public static final String TIME_BOUND_VALUE = "TIME_BOUND_VALUE";
    public static final String SELECTED_RULE_CHECKER = "SELECTED_RULE_CHECKER";
    public static final String CONFIG_JSON_FILE = "config.json";
    public static final String SAFE_ENGINE_JAR = "jsa-engine-1.1.jar";
    public static IPreferenceStore store = null;
    public static String toolsPath = null;

    static {
        store = JsaPlugin.getDefault().getPreferenceStore();
        toolsPath = InstallPathConfig.getToolsPath();
    }

    private Settings() {
    }

    public static IPreferenceStore getStore() {
        return store;
    }

    public static boolean isEmpty(String str) {
        if (str == null) {
            return true;
        }
        int i = 0;
        int n = str.length();
        while (i < n) {
            if (!Character.isWhitespace(str.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String[] getRuleNumbers(String numStr) {
        if (Settings.isEmpty(numStr)) {
            return null;
        }
        String[] ruleNumbers = numStr.split(",");
        return ruleNumbers;
    }

    public static boolean isSetConfigFile() {
        File config = new File(String.valueOf(toolsPath) + File.separator + "jsa" + File.separator + CONFIG_JSON_FILE);
        return config.exists();
    }

    public static void writeConfigFile() {
        String[] ruleNumbers = Settings.getRuleNumbers(Settings.getStore().getString(SELECTED_RULE_CHECKER));
        boolean isTizenAPIVerCheck = false;
        if (ruleNumbers != null) {
            StringBuilder webapiRules = new StringBuilder();
            webapiRules.append("[");
            StringBuilder codingRules = new StringBuilder();
            codingRules.append("[");
            String[] stringArray = ruleNumbers;
            int n = ruleNumbers.length;
            int n2 = 0;
            while (n2 < n) {
                String rule = stringArray[n2];
                int num = Integer.valueOf(rule);
                if (num >= 30 && num < 40) {
                    if (webapiRules.length() != 1) {
                        webapiRules.append(",");
                    }
                    webapiRules.append("\"" + rule + "\"");
                    if (num == 38) {
                        isTizenAPIVerCheck = true;
                    }
                }
                if (num >= 50 && num < 70) {
                    if (codingRules.length() != 1) {
                        codingRules.append(",");
                    }
                    codingRules.append("\"" + rule + "\"");
                }
                ++n2;
            }
            webapiRules.append("]");
            codingRules.append("]");
            StringBuilder tizenApis = null;
            if (isTizenAPIVerCheck) {
                tizenApis = new StringBuilder();
                tizenApis.append("\"tizen-apis\" : [");
                tizenApis.append(" { \"mobile-2.3.1\" : ");
                String filePathA = String.valueOf(toolsPath) + File.separator + "jsa" + File.separator + "db" + File.separator;
                tizenApis.append("\"" + Settings.getWindowsFilePath(filePathA));
                tizenApis.append("mobile-2.3.db\" }, ");
                tizenApis.append("{ \"wearable-2.3.1\" : ");
                String filePathB = String.valueOf(toolsPath) + File.separator + "jsa" + File.separator + "db" + File.separator;
                tizenApis.append("\"" + Settings.getWindowsFilePath(filePathB));
                tizenApis.append("wearable-2.3.db\" } ");
                tizenApis.append("]");
            }
            String selectedRuleChecker = "{\"webapi-rule-checker\":" + webapiRules.toString() + ", \"coding-rule-checker\":" + codingRules.toString();
            selectedRuleChecker = isTizenAPIVerCheck ? String.valueOf(selectedRuleChecker) + ", " + tizenApis.toString() + "}" : String.valueOf(selectedRuleChecker) + "}";
            IOUtil.getInstance().writeToFile(String.valueOf(toolsPath) + File.separator + "jsa" + File.separator + CONFIG_JSON_FILE, selectedRuleChecker);
        } else {
            IOUtil.getInstance().writeToFile(String.valueOf(toolsPath) + File.separator + "jsa" + File.separator + CONFIG_JSON_FILE, "");
        }
    }

    public static String getWindowsFilePath(String path) {
        if (OSChecker.isWindows()) {
            String filePath = path;
            filePath = filePath.replace("\\", "\\\\");
            return filePath;
        }
        return path;
    }

    public static String getSafeDir() {
        String workingDir = Settings.getStore().getString(SAFE_LOCATION_PATH);
        if (!Settings.isEmpty(workingDir)) {
            Path path = new Path(workingDir);
            workingDir = path.removeLastSegments(1).toOSString();
        } else {
            workingDir = null;
        }
        return workingDir;
    }
}

