/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.iter;

import edu.rice.cs.plt.iter.AbstractIterable;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.iter.OptimizedLastIterable;
import edu.rice.cs.plt.iter.PermutationIterator;
import edu.rice.cs.plt.iter.SizedIterable;
import edu.rice.cs.plt.iter.SnapshotIterable;
import edu.rice.cs.plt.object.Composite;
import edu.rice.cs.plt.object.ObjectUtil;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PermutationIterable<T>
extends AbstractIterable<Iterable<T>>
implements SizedIterable<Iterable<T>>,
OptimizedLastIterable<Iterable<T>>,
Composite,
Serializable {
    private final Iterable<? extends T> _original;

    public PermutationIterable(Iterable<? extends T> original) {
        this._original = original;
    }

    @Override
    public PermutationIterator<T> iterator() {
        return new PermutationIterator<T>(this._original);
    }

    @Override
    public int compositeHeight() {
        return ObjectUtil.compositeHeight(this._original) + 1;
    }

    @Override
    public int compositeSize() {
        return ObjectUtil.compositeSize(this._original) + 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public int size() {
        return this.size(Integer.MAX_VALUE);
    }

    @Override
    public int size(int bound) {
        int n = IterUtil.sizeOf(this._original, bound);
        long result = 1L;
        for (int i = 2; i < n && result < (long)bound; result *= (long)i, ++i) {
        }
        return result <= (long)bound ? (int)result : bound;
    }

    @Override
    public boolean isInfinite() {
        return IterUtil.isInfinite(this._original);
    }

    @Override
    public boolean hasFixedSize() {
        return IterUtil.hasFixedSize(this._original);
    }

    @Override
    public boolean isStatic() {
        return IterUtil.isStatic(this._original);
    }

    @Override
    public Iterable<T> last() {
        return IterUtil.reverse(this._original);
    }

    public static <T> PermutationIterable<T> make(Iterable<? extends T> original) {
        return new PermutationIterable<T>(original);
    }

    public static <T> SnapshotIterable<Iterable<T>> makeSnapshot(Iterable<? extends T> original) {
        return new SnapshotIterable<T>(new PermutationIterable<T>(original));
    }
}

