/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class TemporaryFile {
    private static final String outputDir;

    public static File urlToFile(String fileName, URL input) throws IOException {
        File F = new File(outputDir + File.separator + fileName);
        return TemporaryFile.urlToFile(F, input);
    }

    public static File urlToFile(File F, URL input) throws IOException {
        return TemporaryFile.streamToFile(F, input.openStream());
    }

    public static File streamToFile(File F, InputStream ... inputs) throws IOException {
        FileOutputStream output = new FileOutputStream(F);
        byte[] buffer = new byte[1024];
        for (InputStream input : inputs) {
            int read;
            while ((read = input.read(buffer)) != -1) {
                output.write(buffer, 0, read);
            }
            input.close();
        }
        output.close();
        return F;
    }

    static {
        String dir = System.getProperty("java.io.tmpdir");
        while (dir.endsWith(File.separator)) {
            dir = dir.substring(0, dir.length() - 1);
        }
        outputDir = dir = dir + File.separator;
    }
}

