/*
 * Decompiled with CFR 0.152.
 */
package com.jgraph.components.labels;

import com.jgraph.components.labels.RichTextBusinessObject;
import com.jgraph.components.labels.RichTextEditor;
import com.jgraph.components.labels.RichTextValue;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.geom.Rectangle2D;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.jgraph.JGraph;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellView;
import org.jgraph.graph.DefaultGraphCellEditor;
import org.jgraph.graph.GraphCellEditor;
import org.jgraph.graph.GraphConstants;

public class RichTextEditor
extends DefaultGraphCellEditor {
    public Component getGraphCellEditorComponent(JGraph jGraph, Object object, boolean bl) {
        Component component = super.getGraphCellEditorComponent(jGraph, object, bl);
        CellView cellView = jGraph.getGraphLayoutCache().getMapping(object, false);
        Rectangle2D rectangle2D = cellView.getBounds();
        this.editingComponent.setBounds((int)rectangle2D.getX(), (int)rectangle2D.getY(), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
        Font font = GraphConstants.getFont(cellView.getAllAttributes());
        this.editingComponent.setFont(font != null ? font : jGraph.getFont());
        return component;
    }

    protected GraphCellEditor createGraphCellEditor() {
        return new RealCellEditor();
    }

    protected Container createContainer() {
        return new ModifiedEditorContainer();
    }

    static /* synthetic */ Container access$200(RichTextEditor richTextEditor) {
        return richTextEditor.editingContainer;
    }

    class ModifiedEditorContainer
    extends DefaultGraphCellEditor.EditorContainer {
        ModifiedEditorContainer() {
            super(RichTextEditor.this);
        }

        public void doLayout() {
            super.doLayout();
            Dimension dimension = this.getSize();
            Dimension dimension2 = RichTextEditor.this.editingComponent.getSize();
            RichTextEditor.this.editingComponent.setSize(dimension2.width - 2, dimension2.height);
            this.setSize(dimension.width, this.getPreferredSize().height);
        }
    }

    class RealCellEditor
    extends AbstractCellEditor
    implements GraphCellEditor {
        JTextPane editorComponent = new JTextPane();

        public RealCellEditor() {
            this.editorComponent.setBorder(UIManager.getBorder("Tree.editorBorder"));
            this.editorComponent.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0), "enter");
            this.editorComponent.getInputMap(0).put(KeyStroke.getKeyStroke(10, 64), "metaEnter");
            this.editorComponent.getInputMap(0).put(KeyStroke.getKeyStroke(10, 128), "metaEnter");
            this.editorComponent.getActionMap().put("enter", new AbstractAction(this){
                private final /* synthetic */ RealCellEditor this$1;
                {
                    this.this$1 = realCellEditor;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.stopCellEditing();
                }
            });
            this.editorComponent.getActionMap().put("metaEnter", new AbstractAction(this){
                private final /* synthetic */ RealCellEditor this$1;
                {
                    this.this$1 = realCellEditor;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    Document document = this.this$1.editorComponent.getDocument();
                    try {
                        document.insertString(this.this$1.editorComponent.getCaretPosition(), "\n", null);
                    }
                    catch (BadLocationException badLocationException) {
                        badLocationException.printStackTrace();
                    }
                }
            });
        }

        public Component getGraphCellEditorComponent(JGraph jGraph, Object object, boolean bl) {
            Object object2;
            Rectangle2D rectangle2D = jGraph.getCellBounds(object);
            if (rectangle2D != null) {
                object2 = new Dimension((int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
                this.editorComponent.setMaximumSize((Dimension)object2);
            }
            object2 = object;
            object = jGraph.getModel().getValue(object);
            if (object instanceof RichTextBusinessObject && ((RichTextBusinessObject)object).isRichText()) {
                try {
                    CellView cellView;
                    StyledDocument styledDocument = (StyledDocument)this.editorComponent.getDocument();
                    ((RichTextValue)((RichTextBusinessObject)object).getValue()).insertInto(styledDocument);
                    if (styledDocument.getLength() > 0) {
                        styledDocument.remove(styledDocument.getLength() - 1, 1);
                    }
                    if ((cellView = jGraph.getGraphLayoutCache().getMapping(object2, false)) != null) {
                        AttributeMap attributeMap = cellView.getAllAttributes();
                        int n = GraphConstants.getHorizontalAlignment(attributeMap);
                        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
                        n = n == 0 ? 1 : (n == 4 ? 2 : 0);
                        StyleConstants.setAlignment(simpleAttributeSet, n);
                        styledDocument.setParagraphAttributes(0, styledDocument.getLength(), simpleAttributeSet, true);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                this.editorComponent.setText(object.toString());
            }
            this.editorComponent.selectAll();
            this.editorComponent.getDocument().addDocumentListener(new DocumentListener(this){
                private final /* synthetic */ RealCellEditor this$1;
                {
                    this.this$1 = realCellEditor;
                }

                public void updateSize() {
                    SwingUtilities.invokeLater(new Runnable(this){
                        private final /* synthetic */ 3 this$2;
                        {
                            this.this$2 = var1_1;
                        }

                        public void run() {
                            Container container = 3.access$000(this.this$2).editorComponent.getParent();
                            if (container != null) {
                                container.doLayout();
                                container.setSize(RichTextEditor.access$200(RealCellEditor.access$100(3.access$000(this.this$2))).getPreferredSize());
                                container.invalidate();
                            }
                        }
                    });
                }

                public void insertUpdate(DocumentEvent documentEvent) {
                    this.updateSize();
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    this.updateSize();
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                    this.updateSize();
                }

                static /* synthetic */ RealCellEditor access$000(3 var0) {
                    return var0.this$1;
                }
            });
            return this.editorComponent;
        }

        public Object getCellEditorValue() {
            return new RichTextValue(this.editorComponent.getDocument());
        }

        public boolean shouldSelectCell(EventObject eventObject) {
            this.editorComponent.requestFocus();
            return super.shouldSelectCell(eventObject);
        }

        static /* synthetic */ RichTextEditor access$100(RealCellEditor realCellEditor) {
            return realCellEditor.RichTextEditor.this;
        }
    }
}

