@if "%DEBUG%" == "" @echo off
@rem ##########################################################################
@rem
@rem  lifetime-analysis startup script for Windows
@rem
@rem ##########################################################################

@rem Set local scope for the variables with windows NT shell
if "%OS%"=="Windows_NT" setlocal
setlocal enabledelayedexpansion

@rem Add default JVM options here. You can also use JAVA_OPTS and LIFETIME_ANALYSIS_OPTS to pass JVM options to this script.
set DEFAULT_JVM_OPTS=

set DIRNAME=%~dp0
if "%DIRNAME%" == "" set DIRNAME=.
set APP_BASE_NAME=%~n0
set APP_HOME=%DIRNAME%..


set prevLine=
set emptyVar=

:updateIniAndExecute
	call :readInfo
	call :setExecPath
	goto init

:readInfo
	set sdkInfoPath=%APP_HOME%\..\..\..\..\..\..\..\sdk.info
	set JDK_PATH=%APP_HOME%\..\..\..\..\..\..\..\jdk

	rem extracting the paths from sdk.info
	for /F "delims=" %%a in (!sdkInfoPath!) do (
		set paths=%%a
		for /f "tokens=1,2 delims==" %%b in ("!paths!") do (
	 		if %%b==TIZEN_SDK_DATA_PATH (
				set sdkDataPath=%%c
	 		)
	 		if %%b==JDK_PATH (
				set sdkInfoJDKPath=%%c
	 		)
	 		if %%b==TIZEN_SDK_INSTALLED_PATH (
				set sdkPath=%%c
	 		)
		)		
	)
	goto omega

:createLogFile
	set hour=%time:~0,2%
	if "%hour:~0,1%" == " " set hour=0%hour:~1,1%

	set min=%time:~3,2%
	if "%min:~0,1%" == " " set min=0%min:~1,1%

	set secs=%time:~6,2%
	if "%secs:~0,1%" == " " set secs=0%secs:~1,1%

	set year=%date:~-4%

	set month=%date:~3,2%
	if "%month:~0,1%" == " " set month=0%month:~1,1%

	set day=%date:~0,2%
	if "%day:~0,1%" == " " set day=0%day:~1,1%

	set fileName=lifetime_analysis_%year%%month%%day%%hour%%min%%secs%.txt
	set "logFilePath=%sdkDataPath%\jsa"
	if not exist %logFilePath% (
		mkdir -p "%logFilePath%"
	)
	set "logFile=!logFilePath!\!fileName!"
	echo. 2>!logFile!
	set logFileCreated=true
	goto omega

:updateLogFile
	if !logFileCreated!==false (
		call :createLogFile
	)
	call echo %1>>!logFile!
	goto omega


:setExecPath
	rem set the java exec path to be used
	rem update JAVA_EXEC if JDK_PATH specified and exists in sdk.info
	set "logFileCreated=false"
	if exist "%sdkInfoJDKPath%" (
		rem jdk directory exixts
		set JDK_PATH=%sdkInfoJDKPath%
		call :updateLogFile "Using Sdk.info java at !JDK_PATH!"
	) else (
		if not !sdkInfoJDKPath!==!emptyVar! (
			call :updateLogFile "Jdk specified in sdk.info:!sdkInfoJDKPath! does not exist."
		)
	)
	if not exist "!JDK_PATH!" (
		set JAVA_EXE=javaw.exe
		call :updateLogFile "Using System java"
	) else (
		set JAVA_EXE=!JDK_PATH!\bin\javaw.exe
	)

	goto omega


:init
@rem Get command-line arguments, handling Windowz variants

if not "%OS%" == "Windows_NT" goto win9xME_args
if "%@eval[2+2]" == "4" goto 4NT_args

:win9xME_args
@rem Slurp the command line arguments.
set CMD_LINE_ARGS=
set _SKIP=2

:win9xME_args_slurp
if "x%~1" == "x" goto execute

set CMD_LINE_ARGS=%*
goto execute

:4NT_args
@rem Get arguments from the 4NT Shell from JP Software
set CMD_LINE_ARGS=%$

:execute
@rem Setup the command line

set CLASSPATH=%APP_HOME%\lib\lifetime-analysis.jar;%APP_HOME%\lib\jopt-simple-4.6.jar;%APP_HOME%\lib\gson-2.2.4.jar;%APP_HOME%\lib\com.ibm.wala.util-1.3.7-SNAPSHOT.jar;%APP_HOME%\lib\jgrapht-core-0.9.0.jar;%APP_HOME%\lib\jgrapht-ext-0.9.0.jar;%APP_HOME%\lib\jgrapht-ext-0.9.0-uber.jar;%APP_HOME%\lib\jgrapht-demo-0.9.0.jar;%APP_HOME%\lib\jgraphx-2.0.0.1.jar;%APP_HOME%\lib\jgraph-5.13.0.0.jar

@rem Execute lifetime-analysis
"%JAVA_EXE%" %DEFAULT_JVM_OPTS% %JAVA_OPTS% %LIFETIME_ANALYSIS_OPTS%  -classpath "%CLASSPATH%" com.samsung.memoryanalysis.driver.CommandLineDriver %CMD_LINE_ARGS%

:end
@rem End local scope for the variables with windows NT shell
if "%ERRORLEVEL%"=="0" goto mainEnd

:fail
rem Set variable LIFETIME_ANALYSIS_EXIT_CONSOLE if you need the _script_ return code instead of
rem the _cmd.exe /c_ return code!
if  not "" == "%LIFETIME_ANALYSIS_EXIT_CONSOLE%" exit 1
exit /b 1

:mainEnd
if "%OS%"=="Windows_NT" endlocal

:omega
