/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.sensor.proximity;

import com.google.protobuf.GeneratedMessage;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.tizen.ecp.legacy.InjectorMessage;
import org.tizen.ecp.msg.genmsg.ecs.Ecs;
import org.tizen.ecp.sensor.proximity.ProximityConstants;
import org.tizen.ecp.sock.EventMgr;
import org.tizen.ecp.sock.ILsn;
import org.tizen.ecp.sock.MessageSender;
import org.tizen.ecp.timer.MessageTimer;
import org.tizen.ecp.utils.FormUtil;
import org.tizen.ecp.utils.LogUtil;
import org.tizen.ecp.views.ECPSubView;
import org.tizen.ecp.views.PropertyView;
import org.tizen.ecp.widgets.ECPButton;

public class ProximityDisplay
extends ECPSubView {
    private ECPButton[] buttons = new ECPButton[2];
    private int proximity_status;
    private static Logger logger = LogUtil.getECPLogger(ProximityDisplay.class).getLogger();
    private SelectionAdapter selectionAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            if (ProximityDisplay.this.proximity_status == 8 && selectionEvent.widget == ProximityDisplay.this.buttons[0]) {
                ProximityDisplay.this.proximity_status = 0;
                ProximityDisplay.this.send(ProximityDisplay.this.proximity_status);
            } else if (ProximityDisplay.this.proximity_status == 0 && selectionEvent.widget == ProximityDisplay.this.buttons[1]) {
                ProximityDisplay.this.proximity_status = 8;
                ProximityDisplay.this.send(ProximityDisplay.this.proximity_status);
            }
        }
    };

    public ProximityDisplay() {
        this.title = "Sensor";
        this.pageHeight = 100;
        this.useTimer = true;
    }

    public void createView(Composite composite) {
        FormUtil.createLabel((Composite)composite, (String)"Proximity", (Font)ProximityConstants.TITLE_FONT, (Color)ProximityConstants.TITLE_COLOR);
        Composite composite2 = FormUtil.createComposite((Composite)composite);
        GridData gridData = new GridData();
        gridData.heightHint = 5;
        composite2.setLayoutData((Object)gridData);
        Composite composite3 = FormUtil.createComposite((Composite)composite, (int)2);
        gridData = FormUtil.createGD();
        gridData.widthHint = 103;
        gridData.horizontalIndent = 20;
        this.buttons[0] = FormUtil.createECPButton((Composite)composite3, (String)"ON", (int)16);
        this.buttons[1] = FormUtil.createECPButton((Composite)composite3, (String)"OFF", (int)16);
        this.buttons[0].setLayoutData((Object)gridData);
        this.buttons[1].setLayoutData((Object)gridData);
        this.buttons[0].addSelectionListener((SelectionListener)this.selectionAdapter);
        this.buttons[1].addSelectionListener((SelectionListener)this.selectionAdapter);
    }

    public void OnTimerMessageExpired() {
        MessageSender.getInstance().sendDeviceReq("sensor", 15, 114);
    }

    protected void initializeWidget() {
        this.buttons[1].setSelection(true);
        this.proximity_status = 8;
    }

    public void setPropertyItems(PropertyView propertyView, Tree tree) {
        propertyView.setTreeItem(tree, new String[]{"Proximity", ""});
    }

    public void send(int n) {
        try {
            if (!MessageTimer.getInstance().isRunning()) {
                MessageTimer.getInstance().RestartTimer();
            }
        }
        catch (Exception exception) {
            logger.severe(exception.getMessage());
        }
        InjectorMessage injectorMessage = new InjectorMessage(n);
        MessageSender.getInstance().sendDeviceReq("sensor", 0, 0, "2\n" + injectorMessage.getMessage());
    }

    public void destroyContents(Composite composite) {
        composite.layout(true, true);
    }

    public boolean Create() {
        this.createPage();
        EventMgr.getInstance().AddLsn("sensor", (ILsn)this);
        return true;
    }

    public void OnStatusEventProcPB(GeneratedMessage generatedMessage) {
        Ecs.DeviceNtf deviceNtf;
        long l;
        if (generatedMessage instanceof Ecs.DeviceNtf && 114L == (l = (long)(deviceNtf = (Ecs.DeviceNtf)generatedMessage).getAction())) {
            try {
                int n;
                this.proximity_status = n = Integer.parseInt(deviceNtf.getData().toStringUtf8());
                if (this.proximity_status == 8) {
                    this.buttons[1].selectRadio();
                } else if (this.proximity_status == 0) {
                    this.buttons[0].selectRadio();
                } else {
                    logger.warning("Wrong value received: " + this.proximity_status);
                }
            }
            catch (NumberFormatException numberFormatException) {
                logger.log(Level.SEVERE, "Numberformat", numberFormatException);
            }
        }
    }
}

