/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.nfc;

import com.google.protobuf.GeneratedMessage;
import org.tizen.cli.AbstractEmulatorCLI;
import org.tizen.cli.utils.OutputUtil;
import org.tizen.ecp.msg.genmsg.ecs.Ecs;
import org.tizen.ecp.nfc.NDEFRecord;
import org.tizen.ecp.nfc.NFCEventException;
import org.tizen.ecp.nfc.NFCEventInjector;
import org.tizen.ecp.nfc.NFCEventType;
import org.tizen.ecp.sock.MessageSender;

public class NFCStatusCLI
extends AbstractEmulatorCLI {
    private String TYPE_NFC;

    public NFCStatusCLI() {
        this.messageType = this.TYPE_NFC = "nfc";
    }

    public void printHelp() {
        super.printHelp();
    }

    public int execute() {
        MessageSender.getInstance().sendDeviceReq("nfc", 15, 0);
        this.startRunning();
        return 0;
    }

    public void OnStatusEventProcPB(GeneratedMessage generatedMessage) {
        if (!(generatedMessage instanceof Ecs.DeviceNtf)) {
            return;
        }
        NFCEventInjector nFCEventInjector = new NFCEventInjector();
        Ecs.DeviceNtf deviceNtf = (Ecs.DeviceNtf)generatedMessage;
        String string = deviceNtf.getData().toStringUtf8();
        try {
            nFCEventInjector.getNfcStatus(string);
            OutputUtil.println((String)("Event Type: " + nFCEventInjector.getCurrentEventType().toString()));
            if (nFCEventInjector.getCurrentEventType() == NFCEventType.TAG_DISCOVERED || nFCEventInjector.getCurrentEventType() == NFCEventType.P2P_SEND) {
                OutputUtil.println((String)"Attached NDEF message list:");
                for (NDEFRecord nDEFRecord : nFCEventInjector.getAttachedRecordList()) {
                    OutputUtil.println((String)("\t" + nDEFRecord.toString()));
                }
            }
        }
        catch (NFCEventException nFCEventException) {
            OutputUtil.printError((String)nFCEventException.getMessage());
        }
        this.stopRunning();
    }
}

