/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.USB;

import com.google.protobuf.GeneratedMessage;
import java.io.IOException;
import java.util.logging.Logger;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.tizen.ecp.battery.BatteryDisplay;
import org.tizen.ecp.legacy.InjectorMessage;
import org.tizen.ecp.msg.genmsg.ecs.Ecs;
import org.tizen.ecp.resources.ColorResources;
import org.tizen.ecp.sock.EventMgr;
import org.tizen.ecp.sock.ILsn;
import org.tizen.ecp.sock.MessageSender;
import org.tizen.ecp.timer.MessageTimer;
import org.tizen.ecp.utils.FormUtil;
import org.tizen.ecp.utils.LogUtil;
import org.tizen.ecp.views.ECPSubView;
import org.tizen.ecp.views.PropertyView;
import org.tizen.ecp.widgets.ECPButton;

public class USBDisplay
extends ECPSubView {
    private static Logger logger = LogUtil.getECPLogger(BatteryDisplay.class).getLogger();
    private Composite comp;
    private ECPButton[] radioButton;
    private boolean sensorOn;
    private SelectionAdapter button1Adapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            if (USBDisplay.this.radioButton[0].getSelection() && !USBDisplay.this.sensorOn) {
                USBDisplay.this.sensorOn = true;
                USBDisplay.this.send(1);
            }
        }
    };
    private SelectionAdapter button2Adapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            if (USBDisplay.this.radioButton[1].getSelection() && USBDisplay.this.sensorOn) {
                USBDisplay.this.sensorOn = false;
                USBDisplay.this.send(0);
            }
        }
    };
    private MouseAdapter mouseAdapter = new MouseAdapter(){

        public void mouseDown(MouseEvent mouseEvent) {
            for (int i = 0; i < USBDisplay.this.radioButton.length; ++i) {
                if (!USBDisplay.this.radioButton[i].getSelection()) continue;
                if (i == 0) {
                    USBDisplay.this.radioButton[0].setFocus();
                    continue;
                }
                USBDisplay.this.radioButton[1].setFocus();
            }
        }
    };

    public USBDisplay() {
        this.title = "USB";
        this.pageHeight = 90;
        this.useTimer = true;
    }

    public void createView(Composite composite) {
        this.comp = FormUtil.createComposite((Composite)composite, (int)2, (boolean)true);
        this.comp.setBackground(ColorResources.CONTENTS_BG.getColor());
        this.comp.addMouseListener((MouseListener)this.mouseAdapter);
        this.radioButton = new ECPButton[2];
        this.radioButton[0] = FormUtil.createECPButton((Composite)this.comp, (String)"Connect", (int)16);
        this.radioButton[1] = FormUtil.createECPButton((Composite)this.comp, (String)"Disconnect", (int)16);
        this.radioButton[0].addSelectionListener((SelectionListener)this.button1Adapter);
        this.radioButton[1].addSelectionListener((SelectionListener)this.button2Adapter);
    }

    protected void initializeWidget() {
    }

    public void send(int n) {
        try {
            if (!MessageTimer.getInstance().isRunning()) {
                MessageTimer.getInstance().RestartTimer();
            }
        }
        catch (IOException iOException) {
            logger.severe(iOException.getMessage());
        }
        InjectorMessage injectorMessage = new InjectorMessage(n);
        MessageSender.getInstance().sendInjectorReq("sensor", 0, 0, "10\n" + injectorMessage.getMessage());
    }

    public void destroyContents(Composite composite) {
        composite.layout(true, true);
    }

    public void setPropertyItems(PropertyView propertyView, Tree tree) {
        propertyView.setTreeItem(tree, new String[]{"Connection", ""});
    }

    public boolean Create() {
        this.createPage();
        EventMgr.getInstance().AddLsn("sensor", (ILsn)this);
        return true;
    }

    public void OnTimerMessageExpired() {
        MessageSender.getInstance().sendInjectorReq("sensor", 15, 102);
    }

    public void OnStatusEventProcPB(GeneratedMessage generatedMessage) {
        Ecs.InjectorNtf injectorNtf;
        if (generatedMessage instanceof Ecs.InjectorNtf && 102 == (injectorNtf = (Ecs.InjectorNtf)generatedMessage).getAction()) {
            String string = injectorNtf.getData().toStringUtf8();
            if (string.equals("1")) {
                this.radioButton[0].selectRadio();
                this.sensorOn = true;
            } else {
                this.radioButton[1].selectRadio();
                this.sensorOn = false;
            }
        }
    }
}

