/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.battery;

import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;
import org.tizen.ecp.timer.MessageTimer;
import org.tizen.ecp.util.ImageUtil;
import org.tizen.ecp.utils.SwtUtil;

public class BatterySlider
extends Canvas {
    private Color bgColor = null;
    private int selection = 0;
    private int maxValue = 1;
    private int minValue = 0;
    private Image leftBack = ImageUtil.loadDeviceImage("Battery", "battery_gauge_back_left.png");
    private Image middleBack = ImageUtil.loadDeviceImage("Battery", "battery_gauge_back_middle.png");
    private Image rightBack = ImageUtil.loadDeviceImage("Battery", "battery_gauge_back_right.png");
    private Image bar = ImageUtil.loadDeviceImage("Battery", "battery_gauge_knob.png");
    private Image gauge = ImageUtil.loadDeviceImage("Battery", "battery_gauge.png");
    private int THUMB_WIDTH = 12;
    private int THUMB_HEIGHT = 18;
    private int GAUGE_HEIGHT = 36;
    private Rectangle sliderRect = new Rectangle(0, 0, 0, 0);
    private Rectangle thumbRect = new Rectangle(0, 0, 0, 0);
    private Rectangle areaRect = new Rectangle(0, 0, 0, 0);
    private Rectangle clickRect = new Rectangle(0, 0, 0, 0);
    private boolean mouseDown = false;
    private DisposeListener disposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent disposeEvent) {
            SwtUtil.tryDispose((Object[])new Object[]{BatterySlider.this.leftBack, BatterySlider.this.middleBack, BatterySlider.this.rightBack, BatterySlider.this.bar, BatterySlider.this.gauge});
        }
    };
    private PaintListener paint = new PaintListener(){

        public void paintControl(PaintEvent paintEvent) {
            Canvas canvas = (Canvas)paintEvent.widget;
            Rectangle rectangle = canvas.getClientArea();
            int n = ((BatterySlider)BatterySlider.this).areaRect.x - 5;
            int n2 = ((BatterySlider)BatterySlider.this).areaRect.y;
            if (null != BatterySlider.this.bgColor) {
                paintEvent.gc.setBackground(BatterySlider.this.bgColor);
                paintEvent.gc.fillRectangle(rectangle);
            }
            paintEvent.gc.drawImage(BatterySlider.this.leftBack, n, n2);
            Rectangle rectangle2 = BatterySlider.this.middleBack.getBounds();
            paintEvent.gc.drawImage(BatterySlider.this.middleBack, rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, ((BatterySlider)BatterySlider.this).areaRect.x + 2, n2, ((BatterySlider)BatterySlider.this).areaRect.width - 4, rectangle2.height);
            n = ((BatterySlider)BatterySlider.this).areaRect.x + ((BatterySlider)BatterySlider.this).areaRect.width - 2;
            paintEvent.gc.drawImage(BatterySlider.this.rightBack, n, n2);
            BatterySlider.this.setThumbRect(BatterySlider.this.selection);
            paintEvent.gc.drawImage(BatterySlider.this.bar, ((BatterySlider)BatterySlider.this).thumbRect.x, ((BatterySlider)BatterySlider.this).thumbRect.y);
            Rectangle rectangle3 = BatterySlider.this.gauge.getBounds();
            paintEvent.gc.drawImage(BatterySlider.this.gauge, rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, ((BatterySlider)BatterySlider.this).areaRect.x, ((BatterySlider)BatterySlider.this).areaRect.y + 3, ((BatterySlider)BatterySlider.this).thumbRect.x + BatterySlider.this.THUMB_WIDTH / 2 - ((BatterySlider)BatterySlider.this).areaRect.x, 26);
        }
    };
    private Listener mouseListener = new Listener(){

        public void handleEvent(Event event) {
            Point point = new Point(event.x, event.y);
            if (event.type == 3) {
                if (event.button != 1) {
                    return;
                }
                BatterySlider batterySlider = (BatterySlider)event.widget;
                batterySlider.setFocus();
                if (BatterySlider.this.pointInRect(BatterySlider.this.thumbRect, point)) {
                    BatterySlider.this.mouseDown = true;
                    MessageTimer.getInstance().setMouseDown(BatterySlider.this.mouseDown);
                } else if (BatterySlider.this.clickRect.contains(point)) {
                    BatterySlider.this.setSelection(BatterySlider.this.pointToSelection(point.x));
                }
            } else if (event.type == 4) {
                if (event.button != 1) {
                    return;
                }
                if (BatterySlider.this.mouseDown) {
                    BatterySlider.this.setSelection(BatterySlider.this.pointToSelection(point.x));
                }
                BatterySlider.this.mouseDown = false;
                MessageTimer.getInstance().setMouseDown(BatterySlider.this.mouseDown);
            } else if (event.type == 5 && BatterySlider.this.mouseDown) {
                BatterySlider.this.setPosition(BatterySlider.this.pointToSelection(point.x));
            }
        }
    };
    private ControlAdapter controlListener = new ControlAdapter(){

        public void controlResized(ControlEvent controlEvent) {
            Canvas canvas = (Canvas)controlEvent.widget;
            BatterySlider.this.sliderRect = canvas.getClientArea();
            int n = ((BatterySlider)BatterySlider.this).sliderRect.x + BatterySlider.this.THUMB_WIDTH / 2 + 5;
            int n2 = ((BatterySlider)BatterySlider.this).sliderRect.y + BatterySlider.this.THUMB_HEIGHT;
            ((BatterySlider)BatterySlider.this).areaRect.x = n;
            ((BatterySlider)BatterySlider.this).areaRect.y = n2;
            ((BatterySlider)BatterySlider.this).areaRect.width = ((BatterySlider)BatterySlider.this).sliderRect.x + ((BatterySlider)BatterySlider.this).sliderRect.width - (n + 10);
            ((BatterySlider)BatterySlider.this).areaRect.height = BatterySlider.this.GAUGE_HEIGHT;
            ((BatterySlider)BatterySlider.this).clickRect.x = ((BatterySlider)BatterySlider.this).areaRect.x;
            ((BatterySlider)BatterySlider.this).clickRect.y = ((BatterySlider)BatterySlider.this).areaRect.y;
            ((BatterySlider)BatterySlider.this).clickRect.width = ((BatterySlider)BatterySlider.this).areaRect.width + 3;
            ((BatterySlider)BatterySlider.this).clickRect.height = ((BatterySlider)BatterySlider.this).areaRect.height;
            BatterySlider.this.setThumbRect(BatterySlider.this.selection);
        }
    };

    public BatterySlider(Composite composite, int n) {
        super(composite, 0x20000000 | n);
        this.addListener(3, this.mouseListener);
        this.addListener(4, this.mouseListener);
        this.addListener(5, this.mouseListener);
        this.addPaintListener(this.paint);
        this.addDisposeListener(this.disposeListener);
        this.addControlListener((ControlListener)this.controlListener);
    }

    private boolean pointInRect(Rectangle rectangle, Point point) {
        return point.x > rectangle.x && point.x > rectangle.y && point.x < rectangle.x + rectangle.width && point.y < rectangle.y + rectangle.height;
    }

    private int selectionToPoint(int n) {
        return this.areaRect.x + n * this.areaRect.width / (this.maxValue - this.minValue);
    }

    private int pointToSelection(int n) {
        int n2 = (this.maxValue - this.minValue) * (n - this.areaRect.x) / this.areaRect.width;
        if (n2 < this.minValue) {
            n2 = this.minValue;
        }
        return n2;
    }

    private void setThumbRect(int n) {
        if (n < this.minValue || n > this.maxValue) {
            return;
        }
        int n2 = this.selectionToPoint(n);
        int n3 = this.sliderRect.y;
        this.thumbRect.x = n2 - this.THUMB_WIDTH / 2;
        this.thumbRect.y = n3;
        this.thumbRect.width = this.THUMB_WIDTH;
        this.thumbRect.height = this.THUMB_HEIGHT;
    }

    public void setBackground(Color color) {
        this.bgColor = color;
    }

    public Color getBackground() {
        return this.bgColor;
    }

    public void setMaximum(int n) {
        this.maxValue = n;
    }

    public int getMaximum() {
        return this.maxValue;
    }

    public void setMinimum(int n) {
        this.minValue = n;
    }

    public int getMinimum() {
        return this.minValue;
    }

    public int getSelection() {
        return this.selection;
    }

    private void setPosition(int n) {
        int n2 = n;
        if (n > this.maxValue) {
            n2 = this.maxValue;
        } else if (n < this.minValue) {
            n2 = this.minValue;
        }
        this.selection = n2;
        this.redraw();
    }

    public void setSelection(int n) {
        this.setPosition(n);
        this.notifyListeners(13, new Event());
    }

    public void setValues(int n, int n2, int n3) {
        this.minValue = n2;
        this.maxValue = n3;
        if (n3 < n2) {
            this.maxValue = n2 + 1;
        }
        this.selection = n;
        this.redraw();
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.addListener(13, (Listener)new TypedListener((SWTEventListener)selectionListener));
    }

    public Point computeSize(int n, int n2, boolean bl) {
        Rectangle rectangle;
        int n3 = 0;
        int n4 = 0;
        this.checkWidget();
        if (this.bar != null) {
            rectangle = this.bar.getBounds();
            n3 += rectangle.width;
            n4 += rectangle.height;
        }
        if (this.middleBack != null) {
            rectangle = this.middleBack.getBounds();
            n3 += 21;
            n4 += rectangle.height;
        }
        if (n != -1) {
            n3 = n;
        }
        if (n2 != -1) {
            n4 = n2;
        }
        this.sliderRect.x = 0;
        this.sliderRect.y = 0;
        this.sliderRect.width = n3;
        this.sliderRect.height = n4;
        return new Point(n3, n4);
    }
}

