/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.sensor;

import java.io.File;
import org.kohsuke.args4j.Argument;
import org.tizen.cli.AbstractEmulatorCLI;
import org.tizen.cli.utils.OutputUtil;
import org.tizen.ecp.sensor.accelerometer.AccelFileOperation;
import org.tizen.ecp.sensor.geo.GeoFileOperation;
import org.tizen.ecp.sensor.gyro.GyroFileOperation;

public class SensorFileCLI
extends AbstractEmulatorCLI {
    private static final String ACCEL = "accelerometer";
    private static final String GYRO = "gyroscope";
    private static final String GEO = "magnetic";
    @Argument(required=true, index=0, metaVar="accelerometer gyroscope magnetic")
    String sensor;
    @Argument(required=true, index=1)
    String path1;

    private int filePathValidation(String string) {
        if (this.path1 == null) {
            OutputUtil.printError((String)"\tAt least one file path must be specified.");
            this.printHelp();
            return 25;
        }
        File file = new File(this.path1);
        if (!file.exists()) {
            OutputUtil.printError((String)("\tthe file does not exist: " + this.path1));
            this.printHelp();
            return 25;
        }
        return 0;
    }

    public int execute() {
        boolean bl;
        block8: {
            int n = 0;
            bl = false;
            if (this.sensor == null || !ACCEL.equals(this.sensor) && !GYRO.equals(this.sensor) && !GEO.equals(this.sensor)) {
                OutputUtil.printError((String)"\tSensor must be specified. (accelerometer, gyroscope, or magnetic)");
                this.printHelp();
                return 25;
            }
            n = this.filePathValidation(this.path1);
            if (n != 0) {
                return n;
            }
            try {
                if (ACCEL.equals(this.sensor)) {
                    bl = AccelFileOperation.getInstance().onceInjection(this.path1);
                    break block8;
                }
                if (GYRO.equals(this.sensor)) {
                    bl = GyroFileOperation.getInstance().onceInjection(this.path1);
                    break block8;
                }
                if (GEO.equals(this.sensor)) {
                    bl = GeoFileOperation.getInstance().onceInjection(this.path1);
                    break block8;
                }
                OutputUtil.printError((String)("\tThis is not possible to be here : " + this.sensor));
                return 25;
            }
            catch (InterruptedException interruptedException) {
                OutputUtil.printError((String)"Interrupted.", (Exception)interruptedException);
                return 4;
            }
        }
        if (!bl) {
            OutputUtil.printFail();
            return 128;
        }
        OutputUtil.printOK();
        return 0;
    }
}

