/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.sensor.gyro;

import com.google.protobuf.GeneratedMessage;
import org.kohsuke.args4j.Argument;
import org.tizen.cli.AbstractEmulatorCLI;
import org.tizen.cli.utils.OutputUtil;
import org.tizen.ecp.legacy.InjectorMessage;
import org.tizen.ecp.msg.genmsg.ecs.Ecs;
import org.tizen.ecp.sock.MessageSender;

public class SensorGyroCLI
extends AbstractEmulatorCLI {
    private String TYPE_SENSOR = "sensor";
    @Argument(required=true, index=0)
    double xValue;
    @Argument(required=true, index=1)
    double yValue;
    @Argument(required=true, index=2)
    double zValue;
    private double GYRO_ADJUST = 57.142857142857146;

    public SensorGyroCLI() {
        this.messageType = this.TYPE_SENSOR;
    }

    private boolean checkRange(double d) {
        return d >= -10.0 && d <= 10.0;
    }

    public int execute() {
        if (!this.checkRange(this.xValue)) {
            OutputUtil.println((String)"x is out of range from -10 to 10");
            return 25;
        }
        if (!this.checkRange(this.yValue)) {
            OutputUtil.println((String)"y is out of range from -10 to 10");
            return 25;
        }
        if (!this.checkRange(this.zValue)) {
            OutputUtil.println((String)"z is out of range from -10 to 10");
            return 25;
        }
        InjectorMessage injectorMessage = new InjectorMessage(this.xValue * this.GYRO_ADJUST, this.yValue * this.GYRO_ADJUST, this.zValue * this.GYRO_ADJUST);
        MessageSender.getInstance().sendDeviceReq("sensor", 0, 0, "4\n" + injectorMessage.getMessage());
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            OutputUtil.printError((String)"Interrupted.", (Exception)interruptedException);
        }
        MessageSender.getInstance().sendDeviceReq("sensor", 15, 111);
        this.startRunning();
        if (this.returnValue == 128) {
            OutputUtil.printFail();
        } else {
            OutputUtil.printOK();
        }
        return 0;
    }

    public void OnEventProcPB(String string, GeneratedMessage generatedMessage) {
        if (generatedMessage instanceof Ecs.DeviceAns) {
            Ecs.DeviceAns deviceAns = (Ecs.DeviceAns)generatedMessage;
            int n = deviceAns.getErrcode();
            if (n != 0) {
                this.returnValue = 128;
            }
            this.stopRunning();
        }
    }
}

