/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.nfc;

import com.google.protobuf.GeneratedMessage;
import java.util.logging.Logger;
import org.kohsuke.args4j.Argument;
import org.tizen.cli.AbstractEmulatorCLI;
import org.tizen.cli.utils.OutputUtil;
import org.tizen.ecp.msg.genmsg.ecs.Ecs;
import org.tizen.ecp.nfc.NDEFFormat;
import org.tizen.ecp.nfc.NDEFRecord;
import org.tizen.ecp.nfc.NFCErrorString;
import org.tizen.ecp.nfc.NFCEventException;
import org.tizen.ecp.nfc.NFCEventInjector;
import org.tizen.ecp.nfc.NFCTagType;
import org.tizen.ecp.sock.MessageSender;
import org.tizen.ecp.utils.LogUtil;

public class NFCTagCLI
extends AbstractEmulatorCLI {
    private static Logger logger = LogUtil.getECPLogger(NFCTagCLI.class).getLogger();
    private NFCEventInjector injector;
    private String token = ",";
    private NDEFRecord record = null;
    private NFCTagType tagType;
    private boolean isFinishedGetStatus = false;
    @Argument(required=true, index=0, metaVar="attach detach")
    String event;
    @Argument(required=false, index=1)
    String type;
    @Argument(required=false, index=2)
    String message;
    private String TYPE_NFC;

    public NFCTagCLI() {
        this.messageType = this.TYPE_NFC = "nfc";
    }

    public void printHelp() {
        super.printHelp();
    }

    public void parseArgs(String string) throws NFCEventException {
        this.record = null;
        if (string == null) {
            throw new NFCEventException(NFCErrorString.NullRecord);
        }
        String[] stringArray = string.split(this.token);
        if (stringArray.length > 4) {
            throw new NFCEventException(NFCErrorString.WrongArgument);
        }
        NDEFFormat nDEFFormat = null;
        for (NDEFFormat nDEFFormat2 : NDEFFormat.values()) {
            if (!nDEFFormat2.getShortName().equals(stringArray[0])) continue;
            nDEFFormat = nDEFFormat2;
            break;
        }
        if (nDEFFormat == null) {
            throw new NFCEventException(NFCErrorString.NotExistNDEFFormat);
        }
        this.record = new NDEFRecord(nDEFFormat, stringArray[1], stringArray[2], stringArray[3]);
    }

    public int execute() {
        logger.info("execute getStatus: " + this.isFinishedGetStatus);
        this.injector = new NFCEventInjector();
        MessageSender.getInstance().sendDeviceReq("nfc", 15, 0);
        logger.info("start");
        this.startRunning();
        logger.info("end");
        return 0;
    }

    public void OnStatusEventProcPB(GeneratedMessage generatedMessage) {
        block7: {
            if (!(generatedMessage instanceof Ecs.DeviceNtf)) {
                return;
            }
            logger.info("OnStatusEventProcPB");
            Ecs.DeviceNtf deviceNtf = (Ecs.DeviceNtf)generatedMessage;
            String string = deviceNtf.getData().toStringUtf8();
            try {
                this.injector.getNfcStatus(string);
                if (this.isFinishedGetStatus) {
                    this.isFinishedGetStatus = false;
                    logger.info("[stop]getStatus: " + this.isFinishedGetStatus);
                    OutputUtil.printOK();
                    this.stopRunning();
                    return;
                }
                if (this.event.equals("attach")) {
                    this.tagType = this.injector.getTagType(this.type);
                    this.parseArgs(this.message);
                    this.injector.addNDEFRecord(this.record);
                    this.injector.sendTagDiscovered(this.tagType);
                    break block7;
                }
                if (this.event.equals("detach")) {
                    if (this.message != null) {
                        throw new NFCEventException(NFCErrorString.WrongArgument);
                    }
                    this.injector.sendTagDetached();
                    break block7;
                }
                throw new NFCEventException(NFCErrorString.WrongArgument);
            }
            catch (NFCEventException nFCEventException) {
                OutputUtil.printError((String)nFCEventException.getMessage());
                this.stopRunning();
                return;
            }
        }
        this.isFinishedGetStatus = true;
        logger.info("getStatus: " + this.isFinishedGetStatus);
        MessageSender.getInstance().sendDeviceReq("nfc", 15, 0);
    }
}

