/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.sensor.geo;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.tizen.ecp.legacy.InjectorMessage;
import org.tizen.ecp.sensor.accelerometer.AccConstants;
import org.tizen.ecp.sensor.accelerometer.AccelerometerDisplay;
import org.tizen.ecp.sensor.geo.GeoFileFinished;
import org.tizen.ecp.sensor.geo.GeoFileOperation;
import org.tizen.ecp.sock.MessageSender;
import org.tizen.ecp.utils.FormUtil;
import org.tizen.ecp.utils.LogUtil;
import org.tizen.ecp.utils.SwtUtil;
import org.tizen.ecp.widgets.ECPButton;
import org.tizen.ecp.widgets.ECPSlider;

public class MagneticDisplay
implements GeoFileFinished {
    private AccelerometerDisplay display;
    private Logger logger = LogUtil.getECPLogger(MagneticDisplay.class).getLogger();
    private ECPSlider xSlider;
    private ECPSlider ySlider;
    private ECPSlider zSlider;
    private Text xText;
    private Text yText;
    private Text zText;
    int xValue;
    int yValue;
    int zValue;
    private Text filenameText;
    private Text repeatText;
    private ECPButton startButton;
    private ECPButton stopButton;
    private ECPButton deleteButton;
    private ECPButton addButton;
    private Table table;
    private int repeatCount = 1;
    private int fileCnt = 0;
    private SelectionAdapter sliderSelection = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            if (selectionEvent.widget == MagneticDisplay.this.xSlider) {
                int n;
                MagneticDisplay.this.xValue = n = MagneticDisplay.this.xSlider.getSelection() - 2000;
                MagneticDisplay.this.xText.setText(Integer.toString(MagneticDisplay.this.xValue));
            } else if (selectionEvent.widget == MagneticDisplay.this.ySlider) {
                int n;
                MagneticDisplay.this.yValue = n = MagneticDisplay.this.ySlider.getSelection() - 2000;
                MagneticDisplay.this.yText.setText(Integer.toString(MagneticDisplay.this.yValue));
            } else if (selectionEvent.widget == MagneticDisplay.this.zSlider) {
                int n;
                MagneticDisplay.this.zValue = n = MagneticDisplay.this.zSlider.getSelection() - 2000;
                MagneticDisplay.this.zText.setText(Integer.toString(MagneticDisplay.this.zValue));
            }
            MagneticDisplay.this.sendMessage();
        }
    };
    private SelectionAdapter textSelection = new SelectionAdapter(){

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            String string = null;
            if (selectionEvent.widget == MagneticDisplay.this.xText) {
                string = MagneticDisplay.this.xText.getText().trim();
            } else if (selectionEvent.widget == MagneticDisplay.this.yText) {
                string = MagneticDisplay.this.yText.getText().trim();
            } else if (selectionEvent.widget == MagneticDisplay.this.zText) {
                string = MagneticDisplay.this.zText.getText().trim();
            }
            if (string == null || string.length() == 0 || "-".equals(string) || string.endsWith(".")) {
                return;
            }
            try {
                if (!FormUtil.isNumeric((String)string) || Integer.parseInt(string) < -2000 || Integer.parseInt(string) > 2000) {
                    throw null;
                }
            }
            catch (NumberFormatException numberFormatException) {
                Shell shell = MagneticDisplay.this.display.getComposite().getShell();
                SwtUtil.openInfoDialog((Shell)shell, (String)"Emulator Control Panel", (String)"Please enter the correct value.\nThe value can be entered in the range of -2000  to 2000.");
                if (selectionEvent.widget == MagneticDisplay.this.xText) {
                    MagneticDisplay.this.xText.setText(Integer.toString(MagneticDisplay.this.xValue));
                } else if (selectionEvent.widget == MagneticDisplay.this.yText) {
                    MagneticDisplay.this.yText.setText(Integer.toString(MagneticDisplay.this.yValue));
                } else if (selectionEvent.widget == MagneticDisplay.this.zText) {
                    MagneticDisplay.this.zText.setText(Integer.toString(MagneticDisplay.this.zValue));
                }
                return;
            }
            catch (Exception exception) {
                Shell shell = MagneticDisplay.this.display.getComposite().getShell();
                SwtUtil.openInfoDialog((Shell)shell, (String)"Emulator Control Panel", (String)"Please enter the correct value.\nThe value can be entered in the range of -2000  to 2000.");
                if (selectionEvent.widget == MagneticDisplay.this.xText) {
                    MagneticDisplay.this.xText.setText(Integer.toString(MagneticDisplay.this.xValue));
                } else if (selectionEvent.widget == MagneticDisplay.this.yText) {
                    MagneticDisplay.this.yText.setText(Integer.toString(MagneticDisplay.this.yValue));
                } else if (selectionEvent.widget == MagneticDisplay.this.zText) {
                    MagneticDisplay.this.zText.setText(Integer.toString(MagneticDisplay.this.zValue));
                }
                return;
            }
            if (selectionEvent.widget == MagneticDisplay.this.xText) {
                MagneticDisplay.this.xValue = Integer.parseInt(string);
                int n = MagneticDisplay.this.xValue + 2000;
                MagneticDisplay.this.xSlider.setSelection(n);
            } else if (selectionEvent.widget == MagneticDisplay.this.yText) {
                MagneticDisplay.this.yValue = Integer.parseInt(string);
                int n = MagneticDisplay.this.yValue + 2000;
                MagneticDisplay.this.ySlider.setSelection(n);
            } else if (selectionEvent.widget == MagneticDisplay.this.zText) {
                MagneticDisplay.this.zValue = Integer.parseInt(string);
                int n = MagneticDisplay.this.zValue + 2000;
                MagneticDisplay.this.zSlider.setSelection(n);
            }
            MagneticDisplay.this.sendMessage();
        }
    };

    public MagneticDisplay(AccelerometerDisplay accelerometerDisplay) {
        this.display = accelerometerDisplay;
        GeoFileOperation.getInstance().registerFileOperation(this);
    }

    public void createDisplay(Composite composite) {
        this.createUserMagnetic(composite);
        this.createFileInput(composite);
    }

    private void setDefaultValue(ECPSlider eCPSlider) {
        eCPSlider.setValues(2000, 0, 4000, 1, 1, 100);
    }

    private ECPSlider createSlider(Composite composite) {
        ECPSlider eCPSlider = FormUtil.createECPSlider((Composite)composite);
        this.setDefaultValue(eCPSlider);
        eCPSlider.setLayoutData((Object)FormUtil.createGD((int)290, (int)22, (int)0, (int)4));
        eCPSlider.addSelectionListener((SelectionListener)this.sliderSelection);
        return eCPSlider;
    }

    private Text createText(Composite composite, String string) {
        Text text = FormUtil.createText((Composite)composite, (String)string);
        text.setLayoutData((Object)FormUtil.createGD((int)40, (int)22));
        text.setTextLimit(8);
        text.addSelectionListener((SelectionListener)this.textSelection);
        return text;
    }

    private void createUserMagnetic(Composite composite) {
        FormUtil.createLabel((Composite)composite, (String)"Magnetic");
        Composite composite2 = FormUtil.createComposite((Composite)composite, (int)4);
        GridData gridData = FormUtil.createHGD();
        gridData.widthHint = 491;
        composite2.setLayoutData((Object)FormUtil.createHGD());
        FormUtil.createLabel((Composite)composite2, (String)"X : ");
        this.xSlider = this.createSlider(composite2);
        this.xValue = 0;
        this.xText = this.createText(composite2, Integer.toString(this.xValue));
        FormUtil.createLabel((Composite)composite2, (String)"[\u00b5T]", (Font)AccConstants.UNIT_FONT_SIZE);
        FormUtil.createLabel((Composite)composite2, (String)"Y : ");
        this.ySlider = this.createSlider(composite2);
        this.yValue = 0;
        this.yText = this.createText(composite2, Integer.toString(this.yValue));
        FormUtil.createLabel((Composite)composite2, (String)"[\u00b5T]", (Font)AccConstants.UNIT_FONT_SIZE);
        FormUtil.createLabel((Composite)composite2, (String)"Z : ");
        this.zSlider = this.createSlider(composite2);
        this.zValue = 0;
        this.zText = this.createText(composite2, Integer.toString(this.zValue));
        FormUtil.createLabel((Composite)composite2, (String)"[\u00b5T]", (Font)AccConstants.UNIT_FONT_SIZE);
    }

    private void createFileInput(Composite composite) {
        FormUtil.createLabel((Composite)composite, (String)"File input");
        Composite composite2 = FormUtil.createComposite((Composite)composite, (int)4);
        GridData gridData = FormUtil.createHGD();
        gridData.widthHint = 491;
        composite2.setLayoutData((Object)gridData);
        this.filenameText = FormUtil.createText((Composite)composite2, (String)"");
        gridData = FormUtil.createGD((int)250, (int)22);
        this.filenameText.setLayoutData((Object)gridData);
        this.filenameText.setEditable(false);
        ECPButton eCPButton = FormUtil.createPushButton((Composite)composite2, (String)"Browse");
        eCPButton.setLayoutData((Object)FormUtil.createGD((int)80, (int)22));
        eCPButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FileDialog fileDialog = new FileDialog(new Shell());
                String string = fileDialog.open();
                if (string == null) {
                    return;
                }
                MagneticDisplay.this.filenameText.setText(string);
            }
        });
        this.addButton = FormUtil.createPushButton((Composite)composite2, (String)"Add");
        this.addButton.setLayoutData((Object)FormUtil.createGD((int)80, (int)22));
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                String string = MagneticDisplay.this.filenameText.getText();
                if (string.isEmpty()) {
                    return;
                }
                if (MagneticDisplay.this.fileCnt == 5) {
                    Shell shell = MagneticDisplay.this.display.getComposite().getShell();
                    SwtUtil.openInfoDialog((Shell)shell, (String)"Emulator Control Panel", (String)"The maximum number of files is 5.");
                    return;
                }
                TableItem tableItem = new TableItem(MagneticDisplay.this.table, 0);
                String[] stringArray = new String[]{Integer.toString(++MagneticDisplay.this.fileCnt), string};
                tableItem.setText(stringArray);
                MagneticDisplay.this.startButton.setEnabled(true);
                MagneticDisplay.this.deleteButton.setEnabled(true);
            }
        });
        Composite composite3 = FormUtil.createComposite((Composite)composite, (int)1);
        gridData = FormUtil.createHGD();
        gridData.widthHint = 491;
        composite3.setLayoutData((Object)gridData);
        this.table = new Table(composite3, 2050);
        gridData = FormUtil.createGD((int)430, (int)90);
        this.table.setLayoutData((Object)gridData);
        TableColumn tableColumn = new TableColumn(this.table, 0x1000000);
        TableColumn tableColumn2 = new TableColumn(this.table, 16384);
        tableColumn.setText("No.");
        tableColumn2.setText("          File path");
        tableColumn.setWidth(80);
        tableColumn2.setWidth(350);
        this.table.setHeaderVisible(true);
        Composite composite4 = FormUtil.createComposite((Composite)composite, (int)8);
        FormUtil.createLabel((Composite)composite4, (String)"Repeat :    ");
        ECPButton eCPButton2 = FormUtil.createPushButton((Composite)composite4, (String)"<");
        eCPButton2.setLayoutData((Object)FormUtil.createGD((int)16, (int)22));
        eCPButton2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (MagneticDisplay.this.repeatCount != 1) {
                    MagneticDisplay.this.repeatCount = MagneticDisplay.this.repeatCount - 1;
                }
                MagneticDisplay.this.repeatText.setText(String.format("%d", MagneticDisplay.this.repeatCount));
            }
        });
        this.repeatText = FormUtil.createText((Composite)composite4, (String)String.format("%d", this.repeatCount));
        this.repeatText.setLayoutData((Object)FormUtil.createGD((int)8, (int)22));
        this.repeatText.setEditable(false);
        ECPButton eCPButton3 = FormUtil.createPushButton((Composite)composite4, (String)">");
        eCPButton3.setLayoutData((Object)FormUtil.createGD((int)16, (int)22));
        eCPButton3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (MagneticDisplay.this.repeatCount != 9) {
                    MagneticDisplay.this.repeatCount = MagneticDisplay.this.repeatCount + 1;
                }
                MagneticDisplay.this.repeatText.setText(String.format("%d", MagneticDisplay.this.repeatCount));
            }
        });
        FormUtil.createLabel((Composite)composite4, (String)" ");
        this.startButton = FormUtil.createPushButton((Composite)composite4, (String)"Start");
        this.startButton.setLayoutData((Object)FormUtil.createGD((int)80, (int)22));
        this.startButton.setEnabled(false);
        this.startButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n;
                for (int i = 0; i < MagneticDisplay.this.fileCnt; ++i) {
                    TableItem tableItem = MagneticDisplay.this.table.getItem(i);
                    File file = new File(tableItem.getText(1));
                    if (!file.exists()) continue;
                    GeoFileOperation.getInstance().addFile(file.getPath());
                }
                try {
                    n = Integer.parseInt(MagneticDisplay.this.repeatText.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    MagneticDisplay.this.logger.log(Level.SEVERE, "Number format", numberFormatException);
                    n = 1;
                }
                GeoFileOperation.getInstance().setRepeatCount(n);
                MagneticDisplay.this.startButton.setEnabled(false);
                MagneticDisplay.this.stopButton.setEnabled(true);
                MagneticDisplay.this.deleteButton.setEnabled(false);
                MagneticDisplay.this.addButton.setEnabled(false);
                GeoFileOperation.getInstance().startInjection();
            }
        });
        this.stopButton = FormUtil.createPushButton((Composite)composite4, (String)"Stop");
        this.stopButton.setLayoutData((Object)FormUtil.createGD((int)80, (int)22));
        this.stopButton.setEnabled(false);
        this.stopButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                GeoFileOperation.getInstance().stopInjection();
                MagneticDisplay.this.stopButton.setEnabled(false);
                MagneticDisplay.this.startButton.setEnabled(true);
                MagneticDisplay.this.deleteButton.setEnabled(true);
                MagneticDisplay.this.addButton.setEnabled(true);
            }
        });
        this.deleteButton = FormUtil.createPushButton((Composite)composite4, (String)"Delete");
        this.deleteButton.setLayoutData((Object)FormUtil.createGD((int)80, (int)22));
        this.deleteButton.setEnabled(false);
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int[] nArray = MagneticDisplay.this.table.getSelectionIndices();
                MagneticDisplay.this.fileCnt = MagneticDisplay.this.fileCnt - nArray.length;
                MagneticDisplay.this.table.remove(nArray);
                for (int i = 0; i < MagneticDisplay.this.fileCnt; ++i) {
                    MagneticDisplay.this.table.getItem(i).setText(Integer.toString(i + 1));
                }
                if (MagneticDisplay.this.fileCnt == 0) {
                    MagneticDisplay.this.startButton.setEnabled(false);
                    MagneticDisplay.this.deleteButton.setEnabled(false);
                }
            }
        });
    }

    public void sendMessage() {
        this.xValue = Integer.parseInt(this.xText.getText());
        this.yValue = Integer.parseInt(this.yText.getText());
        this.zValue = Integer.parseInt(this.zText.getText());
        InjectorMessage injectorMessage = new InjectorMessage((double)this.xValue, (double)this.yValue, (double)this.zValue);
        MessageSender.getInstance().sendDeviceReq("sensor", 0, 0, "13\n" + injectorMessage.getMessage());
    }

    public void sendFileMessage(String string) {
        String string2 = String.format("%d%n%d%n%s", this.repeatCount, this.fileCnt, string);
        MessageSender.getInstance().sendInjectorReq("sensor", 0, 0, "15\n" + string2);
    }

    public void sendFileStop() {
        MessageSender.getInstance().sendInjectorReq("sensor", 0, 0, "15\n0\n");
    }

    @Override
    public void fileOpsFinished() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                MagneticDisplay.this.stopButton.setEnabled(false);
                MagneticDisplay.this.startButton.setEnabled(true);
                MagneticDisplay.this.deleteButton.setEnabled(true);
                MagneticDisplay.this.addButton.setEnabled(true);
            }
        });
    }

    public void setStatus(String string) {
        if (!string.isEmpty()) {
            String[] stringArray = string.split(" ");
            this.xText.setText(stringArray[0]);
            this.yText.setText(stringArray[1]);
            this.zText.setText(stringArray[2]);
            int n = Integer.parseInt(stringArray[0]) + 2000;
            this.xSlider.setSelection(n, false);
            int n2 = Integer.parseInt(stringArray[1]) + 2000;
            this.ySlider.setSelection(n2, false);
            int n3 = Integer.parseInt(stringArray[2]) + 2000;
            this.zSlider.setSelection(n3, false);
        }
    }
}

