/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.sensor.gui;

import java.util.Random;
import org.tizen.ecp.sensor.gui.Vector;

public class Magnetic {
    private static Magnetic instance;
    private Random r = new Random();
    private double compassx;
    private double compassy;
    private double compassz;
    private int azimuth = 0;
    private int pitch = -90;
    private int roll = 0;
    private double magneticnorth = 10000.0;
    private double magneticeast = 1000.0;
    private double magneticvertical = 0.0;
    private double read_compassx;
    private double read_compassy;
    private double read_compassz;
    private double partial_compassx;
    private double partial_compassy;
    private double partial_compassz;
    private int partial_compass_n;
    private long compass_update_duration;
    private long compass_next_update;
    private long user_settings_duration = 500L;
    private long user_settings_next_update = System.currentTimeMillis();
    private boolean average_compass = true;

    private Magnetic() {
    }

    public static Magnetic getInstance() {
        if (instance == null) {
            instance = new Magnetic();
        }
        return instance;
    }

    public void setMagneticFiled(double d, double d2, double d3) {
    }

    public void updateSensorPhysics(double d, double d2, double d3) {
        double d4 = 0.0;
        if (d4 > 0.0) {
            this.magneticnorth += this.getRandom(d4);
            this.magneticeast += this.getRandom(d4);
            this.magneticvertical += this.getRandom(d4);
        }
        Vector vector = new Vector(this.magneticeast, this.magneticnorth, -this.magneticvertical);
        vector.scale(0.001);
        vector.reverserollpitchyaw();
        this.compassx = vector.x;
        this.compassy = vector.y;
        this.compassz = vector.z;
    }

    public void setTilt(double d, double d2, double d3) {
        int n = (int)(Math.round(Math.atan2(-d, -d2) * 57.324840764331206 + 360.0) % 360L);
        int n2 = (int)(Math.atan2(d, -d2) * 57.324840764331206);
        int n3 = (int)(Math.atan2(d, -d3) * 57.324840764331206) % 180;
        this.azimuth = n;
        this.pitch = n2;
        this.roll = n3;
    }

    public int getAzimuth() {
        return this.azimuth;
    }

    public int getPitch() {
        return this.pitch;
    }

    public int getRoll() {
        return this.roll;
    }

    public void setAzimuth(int n) {
        this.azimuth = n;
    }

    public void setPitch(int n) {
        this.pitch = n;
    }

    public void setRoll(int n) {
        this.roll = n;
    }

    public void updateSensorReadoutValues() {
        long l = System.currentTimeMillis();
        if (this.average_compass) {
            this.partial_compassx += this.compassx;
            this.partial_compassy += this.compassy;
            this.partial_compassz += this.compassz;
            ++this.partial_compass_n;
        }
        if (l >= this.compass_next_update) {
            this.compass_next_update += this.compass_update_duration;
            if (this.compass_next_update < l) {
                this.compass_next_update = l;
            }
            if (this.average_compass) {
                this.read_compassx = this.partial_compassx / (double)this.partial_compass_n;
                this.read_compassy = this.partial_compassy / (double)this.partial_compass_n;
                this.read_compassz = this.partial_compassz / (double)this.partial_compass_n;
                this.partial_compassx = 0.0;
                this.partial_compassy = 0.0;
                this.partial_compassz = 0.0;
                this.partial_compass_n = 0;
            } else {
                this.read_compassx = this.compassx;
                this.read_compassy = this.compassy;
                this.read_compassz = this.compassz;
            }
        }
    }

    public void updateUserSettings() {
        long l = System.currentTimeMillis();
        if (l >= this.user_settings_next_update) {
            this.user_settings_next_update += this.user_settings_duration;
            if (this.user_settings_next_update < l) {
                this.user_settings_next_update = System.currentTimeMillis();
            }
            this.average_compass = true;
            double d = 10.0;
            this.compass_update_duration = d != 0.0 ? (long)(1000.0 / d) : 0L;
        }
    }

    public double getReadCompassX() {
        return this.read_compassx;
    }

    public double getReadCompassY() {
        return this.read_compassy;
    }

    public double getReadCompassZ() {
        return this.read_compassz;
    }

    private double getRandom(double d) {
        double d2 = this.r.nextDouble();
        return (2.0 * d2 - 1.0) * d;
    }
}

