/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.sensor.hrm;

import com.google.protobuf.GeneratedMessage;
import java.text.DecimalFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.tizen.ecp.dialogs.MessageDialog;
import org.tizen.ecp.legacy.InjectorMessage;
import org.tizen.ecp.msg.genmsg.ecs.Ecs;
import org.tizen.ecp.sensor.hrm.HRMConstants;
import org.tizen.ecp.sock.EventMgr;
import org.tizen.ecp.sock.ILsn;
import org.tizen.ecp.sock.MessageSender;
import org.tizen.ecp.sock.SocketClient;
import org.tizen.ecp.utils.FormUtil;
import org.tizen.ecp.utils.LogUtil;
import org.tizen.ecp.views.ECPSubView;
import org.tizen.ecp.widgets.ECPSlider;

public class HRMDisplay
extends ECPSubView {
    private static Logger logger = LogUtil.getECPLogger(HRMDisplay.class).getLogger();
    private Text hrmText;
    private ECPSlider hrmSlider;
    private Text rriText;
    private ECPSlider rriSlider;
    private int hrmData = 100;
    private int rriData = 600;
    DecimalFormat mf = new DecimalFormat("#0.0");
    private FocusAdapter rriFocusAdapter = new FocusAdapter(){

        public void focusLost(FocusEvent focusEvent) {
            String string = HRMDisplay.this.rriText.getText();
            if (string.isEmpty() || !HRMDisplay.this.validateHrmNumber(string)) {
                HRMDisplay.this.rriText.setText(Integer.toString(HRMDisplay.this.hrmData));
            }
        }
    };
    private FocusAdapter hrmFocusAdapter = new FocusAdapter(){

        public void focusLost(FocusEvent focusEvent) {
            String string = HRMDisplay.this.hrmText.getText();
            if (string.isEmpty() || !HRMDisplay.this.validateHrmNumber(string)) {
                HRMDisplay.this.hrmText.setText(HRMDisplay.this.mf.format((float)HRMDisplay.this.hrmData / 10.0f));
            }
        }
    };
    private SelectionAdapter rriSliderAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            HRMDisplay.this.rriData = HRMDisplay.this.rriSlider.getSelection();
            HRMDisplay.this.rriText.setText(Integer.toString(HRMDisplay.this.rriData));
        }
    };
    private SelectionAdapter hrmSliderAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            HRMDisplay.this.hrmData = HRMDisplay.this.hrmSlider.getSelection();
            HRMDisplay.this.hrmText.setText(HRMDisplay.this.mf.format((float)HRMDisplay.this.hrmData / 10.0f));
        }
    };
    private VerifyListener rriVerify = new VerifyListener(){

        /*
         * Enabled aggressive block sorting
         */
        public void verifyText(VerifyEvent verifyEvent) {
            String string = HRMDisplay.this.rriText.getText();
            if (verifyEvent.character == '\b') {
                if (verifyEvent.end == 1) {
                    string = string.substring(verifyEvent.end, string.length());
                } else {
                    if (verifyEvent.start == 0) {
                        verifyEvent.doit = false;
                        return;
                    }
                    string = string.substring(0, verifyEvent.start) + string.substring(verifyEvent.end, string.length());
                }
            } else if (string.isEmpty() && verifyEvent.text.length() != 0) {
                string = verifyEvent.text;
            } else {
                if (verifyEvent.text.length() == 1 && HRMDisplay.this.checkNumberFormat(verifyEvent.text)) {
                    verifyEvent.doit = false;
                    return;
                }
                string = verifyEvent.start == 0 && verifyEvent.text.length() == 1 && HRMDisplay.this.rriSlider.getSelection() != 0 ? verifyEvent.text.concat(string) : (verifyEvent.start == string.length() ? string.concat(verifyEvent.text) : string.substring(0, verifyEvent.start) + verifyEvent.text + string.substring(verifyEvent.end, string.length()));
            }
            if (HRMDisplay.this.validateRRINumber(string)) {
                HRMDisplay.this.rriData = Integer.parseInt(string);
                HRMDisplay.this.rriSlider.setSelection(HRMDisplay.this.rriData, false);
                HRMDisplay.this.setData();
            }
        }
    };
    private VerifyListener hrmVerify = new VerifyListener(){

        /*
         * Enabled aggressive block sorting
         */
        public void verifyText(VerifyEvent verifyEvent) {
            String string = ((Text)verifyEvent.widget).getText();
            if (verifyEvent.start == 0 && verifyEvent.text.equals("-")) {
                string = verifyEvent.text.concat(string);
            } else if (verifyEvent.character == '\b') {
                if (verifyEvent.end == 1) {
                    string = string.substring(verifyEvent.end, string.length());
                } else {
                    if (verifyEvent.start == 0) {
                        verifyEvent.doit = false;
                        return;
                    }
                    string = string.substring(0, verifyEvent.start) + string.substring(verifyEvent.end, string.length());
                }
            } else {
                if (verifyEvent.text.length() == 1 && HRMDisplay.this.checkNumberFormat(verifyEvent.text)) {
                    verifyEvent.doit = false;
                    return;
                }
                string = verifyEvent.start == 0 && verifyEvent.text.length() == 1 ? verifyEvent.text.concat(string) : (string.isEmpty() && verifyEvent.text.length() != 0 ? verifyEvent.text : (verifyEvent.start == string.length() ? string.concat(verifyEvent.text) : string.substring(0, verifyEvent.start) + verifyEvent.text + string.substring(verifyEvent.end, string.length())));
            }
            if (HRMDisplay.this.validateHrmNumber(string)) {
                HRMDisplay.this.hrmData = (int)(Float.parseFloat(string) * 10.0f);
                HRMDisplay.this.hrmSlider.setSelection(HRMDisplay.this.hrmData, false);
                HRMDisplay.this.setData();
            }
        }
    };

    public HRMDisplay() {
        this.title = "Sensor";
        this.pageHeight = 200;
        this.useTimer = true;
    }

    public void OnTimerMessageExpired() {
        logger.info("OnTimerMessageExpired");
        MessageSender.getInstance().sendDeviceReq("sensor", 15, 118);
    }

    public void createView(Composite composite) {
        FormUtil.createLabel((Composite)composite, (String)"Heart Rate", (Font)HRMConstants.TITLE_FONT, (Color)HRMConstants.TITLE_COLOR);
        Composite composite2 = FormUtil.createComposite((Composite)composite, (int)3);
        FormUtil.createLabel((Composite)composite2, (String)"   x  ", (boolean)true, (int)50);
        this.hrmSlider = FormUtil.createECPSlider((Composite)composite2);
        GridData gridData = FormUtil.createHGD((int)384, (int)21, (int)0, (int)4);
        this.hrmSlider.setLayoutData((Object)gridData);
        this.hrmSlider.addSelectionListener((SelectionListener)this.hrmSliderAdapter);
        this.hrmText = FormUtil.createText((Composite)composite2, (int)0x1000800);
        gridData = FormUtil.createGD((int)50, (int)22);
        this.hrmText.setLayoutData((Object)gridData);
        this.hrmText.setTextLimit(5);
        this.hrmText.addVerifyListener(this.hrmVerify);
        this.hrmText.addFocusListener((FocusListener)this.hrmFocusAdapter);
        FormUtil.createLabel((Composite)composite, (String)" ");
        FormUtil.createLabel((Composite)composite, (String)"Peek-to-Peek", (Font)HRMConstants.TITLE_FONT, (Color)HRMConstants.TITLE_COLOR);
        Composite composite3 = FormUtil.createComposite((Composite)composite, (int)3);
        FormUtil.createLabel((Composite)composite3, (String)"  ms  ", (boolean)true, (int)50);
        this.rriSlider = FormUtil.createECPSlider((Composite)composite3);
        gridData = FormUtil.createHGD((int)384, (int)21, (int)0, (int)4);
        this.rriSlider.setLayoutData((Object)gridData);
        this.rriSlider.addSelectionListener((SelectionListener)this.rriSliderAdapter);
        this.rriText = FormUtil.createText((Composite)composite3, (int)0x1000800);
        gridData = FormUtil.createGD((int)50, (int)22);
        this.rriText.setLayoutData((Object)gridData);
        this.rriText.setTextLimit(4);
        this.rriText.addFocusListener((FocusListener)this.rriFocusAdapter);
        this.rriText.addVerifyListener(this.rriVerify);
    }

    protected void initializeWidget() {
        this.hrmSlider.setValues(this.hrmData, 0, 2200, 1, 1, 100);
        this.rriSlider.setValues(this.rriData, 0, 5000, 1, 1, 100);
    }

    private void setData() {
        if (!SocketClient.getInstance().getGuestStatus()) {
            MessageDialog messageDialog = new MessageDialog();
            messageDialog.openInfoDialog("Emulator is not ready. Please retry when the emulator is ready.");
        } else {
            InjectorMessage injectorMessage = new InjectorMessage(0.0, (double)this.hrmData, (double)this.rriData);
            MessageSender.getInstance().sendDeviceReq("sensor", 0, 0, "22\n" + injectorMessage.getMessage());
        }
    }

    private boolean validateHrmNumber(String string) {
        try {
            if (Float.parseFloat(string) < 1.0f || Float.parseFloat(string) > 220.0f) {
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private boolean checkNumberFormat(String string) {
        Pattern pattern = Pattern.compile("[^0-9]");
        Matcher matcher = pattern.matcher(string);
        return matcher.find();
    }

    private boolean validateRRINumber(String string) {
        try {
            if (Float.parseFloat(string) < 0.0f || Float.parseFloat(string) > 5000.0f) {
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public void destroyContents(Composite composite) {
        composite.layout(true, true);
    }

    public boolean Create() {
        this.createPage();
        EventMgr.getInstance().AddLsn("sensor", (ILsn)this);
        return true;
    }

    public void OnStatusEventProcPB(GeneratedMessage generatedMessage) {
        Ecs.DeviceNtf deviceNtf;
        long l;
        if (generatedMessage instanceof Ecs.DeviceNtf && 118L == (l = (long)(deviceNtf = (Ecs.DeviceNtf)generatedMessage).getAction())) {
            String string = deviceNtf.getData().toStringUtf8();
            try {
                String[] stringArray = string.split(", ");
                this.hrmData = Integer.parseInt(stringArray[0]);
                this.hrmText.setText(this.mf.format((float)this.hrmData / 10.0f));
                this.hrmSlider.setSelection(this.hrmData, false);
                this.rriData = Integer.parseInt(stringArray[1]);
                this.rriText.setText(stringArray[1]);
                this.rriSlider.setSelection(this.rriData, false);
            }
            catch (NumberFormatException numberFormatException) {
                logger.log(Level.SEVERE, "Numberformat", numberFormatException);
            }
        }
    }
}

