/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.sensor.pressure;

import com.google.protobuf.GeneratedMessage;
import java.text.DecimalFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.tizen.ecp.dialogs.MessageDialog;
import org.tizen.ecp.legacy.InjectorMessage;
import org.tizen.ecp.msg.genmsg.ecs.Ecs;
import org.tizen.ecp.sensor.pressure.PressureConstants;
import org.tizen.ecp.sock.EventMgr;
import org.tizen.ecp.sock.ILsn;
import org.tizen.ecp.sock.MessageSender;
import org.tizen.ecp.sock.SocketClient;
import org.tizen.ecp.utils.FormUtil;
import org.tizen.ecp.utils.LogUtil;
import org.tizen.ecp.views.ECPSubView;
import org.tizen.ecp.widgets.ECPSlider;

public class PressureDisplay
extends ECPSubView {
    private static Logger logger = LogUtil.getECPLogger(PressureDisplay.class).getLogger();
    private Text pressText;
    private ECPSlider pressSlider;
    private int pressData = 760;
    private int tempData = 425;
    DecimalFormat mf = new DecimalFormat("#0.0");
    private FocusAdapter pressFocusAdapter = new FocusAdapter(){

        public void focusLost(FocusEvent focusEvent) {
            String string = PressureDisplay.this.pressText.getText();
            if (string.isEmpty() || !PressureDisplay.this.validatePressNumber(string)) {
                PressureDisplay.this.pressText.setText(Integer.toString(PressureDisplay.this.pressData));
            }
        }
    };
    private SelectionAdapter pressSliderAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            PressureDisplay.this.pressData = PressureDisplay.this.pressSlider.getSelection() + 260;
            PressureDisplay.this.pressText.setText(Integer.toString(PressureDisplay.this.pressData));
        }
    };
    private VerifyListener pressVerify = new VerifyListener(){

        /*
         * Enabled aggressive block sorting
         */
        public void verifyText(VerifyEvent verifyEvent) {
            String string = ((Text)verifyEvent.widget).getText();
            if (verifyEvent.character == '\b') {
                if (verifyEvent.end == 1) {
                    string = string.substring(verifyEvent.end, string.length());
                } else {
                    if (verifyEvent.start == 0) {
                        verifyEvent.doit = false;
                        return;
                    }
                    string = string.substring(0, verifyEvent.start) + string.substring(verifyEvent.end, string.length());
                }
            } else if (string.isEmpty() && verifyEvent.text.length() != 0) {
                string = verifyEvent.text;
            } else {
                if (verifyEvent.text.length() == 1 && PressureDisplay.this.checkNumberFormat(verifyEvent.text)) {
                    verifyEvent.doit = false;
                    return;
                }
                string = verifyEvent.start == 0 && verifyEvent.text.length() == 1 ? verifyEvent.text.concat(string) : (verifyEvent.start == string.length() ? string.concat(verifyEvent.text) : string.substring(0, verifyEvent.start) + verifyEvent.text + string.substring(verifyEvent.end, string.length()));
            }
            if (PressureDisplay.this.validatePressNumber(string)) {
                PressureDisplay.this.pressData = Integer.parseInt(string);
                PressureDisplay.this.pressSlider.setSelection(PressureDisplay.this.pressData - 260, false);
                PressureDisplay.this.setData();
            }
        }
    };

    public PressureDisplay() {
        this.title = "Sensor";
        this.pageHeight = 200;
        this.useTimer = true;
    }

    public void OnTimerMessageExpired() {
        logger.info("OnTimerMessageExpired");
        MessageSender.getInstance().sendDeviceReq("sensor", 15, 116);
    }

    public void createView(Composite composite) {
        FormUtil.createLabel((Composite)composite, (String)"Barometer", (Font)PressureConstants.TITLE_FONT, (Color)PressureConstants.TITLE_COLOR);
        Composite composite2 = FormUtil.createComposite((Composite)composite, (int)3);
        FormUtil.createLabel((Composite)composite2, (String)" hPa  ", (boolean)true, (int)50);
        this.pressSlider = FormUtil.createECPSlider((Composite)composite2);
        GridData gridData = FormUtil.createHGD((int)384, (int)21, (int)0, (int)4);
        this.pressSlider.setLayoutData((Object)gridData);
        this.pressSlider.addSelectionListener((SelectionListener)this.pressSliderAdapter);
        this.pressText = FormUtil.createText((Composite)composite2, (int)0x1000800);
        gridData = FormUtil.createGD((int)50, (int)22);
        this.pressText.setLayoutData((Object)gridData);
        this.pressText.setTextLimit(4);
        this.pressText.addFocusListener((FocusListener)this.pressFocusAdapter);
        this.pressText.addVerifyListener(this.pressVerify);
    }

    protected void initializeWidget() {
        this.pressSlider.setValues(this.pressData - 260, 0, 1000, 1, 1, 10);
    }

    private void setData() {
        if (!SocketClient.getInstance().getGuestStatus()) {
            MessageDialog messageDialog = new MessageDialog();
            messageDialog.openInfoDialog("Emulator is not ready. Please retry when the emulator is ready.");
        } else {
            InjectorMessage injectorMessage = new InjectorMessage(this.pressData, this.tempData);
            MessageSender.getInstance().sendDeviceReq("sensor", 0, 0, "20\n" + injectorMessage.getMessage());
        }
    }

    private boolean validatePressNumber(String string) {
        try {
            if (Double.parseDouble(string) < 260.0 || Double.parseDouble(string) > 1260.0) {
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private boolean checkNumberFormat(String string) {
        Pattern pattern = Pattern.compile("[^0-9]");
        Matcher matcher = pattern.matcher(string);
        return matcher.find();
    }

    public void destroyContents(Composite composite) {
        composite.layout(true, true);
    }

    public boolean Create() {
        this.createPage();
        EventMgr.getInstance().AddLsn("sensor", (ILsn)this);
        return true;
    }

    public void OnStatusEventProcPB(GeneratedMessage generatedMessage) {
        Ecs.DeviceNtf deviceNtf;
        long l;
        if (generatedMessage instanceof Ecs.DeviceNtf && 116L == (l = (long)(deviceNtf = (Ecs.DeviceNtf)generatedMessage).getAction())) {
            String string = deviceNtf.getData().toStringUtf8();
            try {
                String[] stringArray = string.split(", ");
                this.pressData = Integer.parseInt(stringArray[0]);
                this.pressText.setText(stringArray[0]);
                this.pressSlider.setSelection(this.pressData - 260, false);
            }
            catch (NumberFormatException numberFormatException) {
                logger.log(Level.SEVERE, "Numberformat", numberFormatException);
            }
        }
    }
}

