/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.sensor.pressure;

import com.google.protobuf.GeneratedMessage;
import org.kohsuke.args4j.Argument;
import org.tizen.cli.AbstractEmulatorCLI;
import org.tizen.cli.utils.OutputUtil;
import org.tizen.ecp.legacy.InjectorMessage;
import org.tizen.ecp.msg.genmsg.ecs.Ecs;
import org.tizen.ecp.sock.MessageSender;

public class SensorPressureCLI
extends AbstractEmulatorCLI {
    private String TYPE_SENSOR;
    @Argument(required=true, index=0)
    int level;

    public SensorPressureCLI() {
        this.messageType = this.TYPE_SENSOR = "sensor";
    }

    public int execute() {
        if (this.level < 260 || this.level > 1260) {
            OutputUtil.printError((String)"level is out of range from 260 to 1260");
            this.printHelp();
            return 25;
        }
        InjectorMessage injectorMessage = new InjectorMessage(this.level, 425);
        MessageSender.getInstance().sendDeviceReq("sensor", 0, 0, "20\n" + injectorMessage.getMessage());
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            OutputUtil.printError((String)"Interrupted.", (Exception)interruptedException);
        }
        MessageSender.getInstance().sendDeviceReq("sensor", 15, 116);
        this.startRunning();
        if (this.returnValue == 128) {
            OutputUtil.printFail();
        } else {
            OutputUtil.printOK();
        }
        return 0;
    }

    public void OnEventProcPB(String string, GeneratedMessage generatedMessage) {
        OutputUtil.debug((String)("pressure: eventname - " + string));
        if (generatedMessage instanceof Ecs.DeviceAns) {
            Ecs.DeviceAns deviceAns = (Ecs.DeviceAns)generatedMessage;
            int n = deviceAns.getErrcode();
            if (n != 0) {
                this.returnValue = 128;
            }
            this.stopRunning();
        }
    }
}

