/*
 * vconf-internal-keys
 *
 * Copyright (c) 2000 - 2013 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Contact: SeungYeup Kim <sy2004.kim@samsung.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

#ifndef __VCONF_INTERNAL_SVOICE_KEYS_H__
#define __VCONF_INTERNAL_SVOICE_KEYS_H__

/**
 * This file defines keys and values.
 *
 * @file        vconf-internal-baby-crying-detector-keys.h
 * @defgroup    vconf_internal_baby_crying_detector_key Definitions of internal shared Keys for Baby Crying Detector
 * @ingroup     vconf_internal_key
 * @author      sy2004.kim@samsung.com
 * @version     0.1
 * @brief       This file has the definitions of shared keys for Baby Crying Detector \n
 */

/* ========================== Baby Crying Detector Keys & Values ============================ */
/**
 * @internal
 * @addtogroup vconf_internal_baby_crying_detector_key
 * @{
 * @brief Baby Crying Detector Keys & Values\n
 *        Maintainer : sy2004.kim@samsung.com
 */

/**
 * @brief It stands for whether the Baby Crying Detector is ON /OFF in setting
 *
 * 1 : Baby Crying Detector is ON \n
 * 0 : Baby Crying Detector is OFF \n
 */
#define VCONFKEY_BABY_CRYING_DETECTOR_STATE "db/baby_crying_detector/state"


/**
 * @}
 */

#endif	/* __VCONF_INTERNAL_SVOICE_KEYS_H__ */

