/*
 * vconf-internal-keys
 *
 * Copyright (c) 2000 - 2011 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Contact: Hakjoo Ko <hakjoo.ko@samsung.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

#ifndef __VCONF_INTERNAL_KEYS_H__
#define __VCONF_INTERNAL_KEYS_H__

/**
 * This file defines keys and values.
 *
 * @file        vconf-internal-keys.h
 * @defgroup    vconf_internal_key Definitions of internal shared Keys
 * @ingroup     vconf_internal_key
 * @author      Hyungdeuk Kim (hd3.kim@samsung.com)
 * @version     0.1
 * @brief       This file has the definitions of internal shared keys.
 * @details     add keys(key name) and values(enum) here for internal shared keys....
 *
 */

#include "vconf-internal-account-keys.h"
#include "vconf-internal-admin-keys.h"
#include "vconf-internal-alarm-keys.h"
#include "vconf-internal-ail-keys.h"
#include "vconf-internal-allshare-keys.h"
#include "vconf-internal-boot-animation-keys.h"
#include "vconf-internal-browser-keys.h"
#include "vconf-internal-bt-keys.h"
#include "vconf-internal-call-keys.h"
#include "vconf-internal-ciss-keys.h"
#include "vconf-internal-csc-keys.h"
#include "vconf-internal-debug-keys.h"
#include "vconf-internal-dnet-keys.h"
#include "vconf-internal-dr-keys.h"
#include "vconf-internal-eas-keys.h"
#include "vconf-internal-factory-keys.h"
#include "vconf-internal-filemanager-keys.h"
#include "vconf-internal-idle-lock-keys.h"
#include "vconf-internal-idle-screen-keys.h"
#include "vconf-internal-location-keys.h"
#include "vconf-internal-lockscreen-keys.h"
#include "vconf-internal-memo-keys.h"
#include "vconf-internal-menuscreen-keys.h"
#include "vconf-internal-miracast-keys.h"
#include "vconf-internal-mobex-connector-keys.h"
#include "vconf-internal-mobex-engine-keys.h"
#include "vconf-internal-mobile-hotspot-keys.h"
#include "vconf-internal-msg-keys.h"
#include "vconf-internal-rcs-keys.h"
#include "vconf-internal-chatonv-keys.h"
#include "vconf-internal-qc-keys.h"
#include "vconf-internal-group-play-keys.h"
#include "vconf-internal-music-keys.h"
#include "vconf-internal-myfile-keys.h"
#include "vconf-internal-nfc-keys.h"
#include "vconf-internal-pm-keys.h"
#include "vconf-internal-pwlock-keys.h"
#include "vconf-internal-radio-keys.h"
#include "vconf-internal-sat-keys.h"
#include "vconf-internal-setting-keys.h"
#include "vconf-internal-sound-keys.h"
#include "vconf-internal-starter-keys.h"
#include "vconf-internal-sysman-keys.h"
#include "vconf-internal-system-keys.h"
#include "vconf-internal-telephony-keys.h"
#include "vconf-internal-testmode-keys.h"
#include "vconf-internal-usb-keys.h"
#include "vconf-internal-voicerecorder-keys.h"
#include "vconf-internal-webkit-keys.h"
#include "vconf-internal-wifi-keys.h"
#include "vconf-internal-dock-keys.h"
#include "vconf-internal-contacts-svc-keys.h"
#include "vconf-internal-crash-keys.h"
#include "vconf-internal-calendar-keys.h"
#include "vconf-internal-camera-keys.h"
#include "vconf-internal-smemo-keys.h"
#include "vconf-internal-kies-via-wifi-keys.h"
#include "vconf-internal-voice-keys.h"
#include "vconf-internal-desktop-mode-keys.h"
#include "vconf-internal-facebook-keys.h"
#include "vconf-internal-ode-keys.h"
#include "vconf-internal-email-keys.h"
#include "vconf-internal-appservice-keys.h"
#include "vconf-internal-svoice-keys.h"
#include "vconf-internal-baby-crying-detector-keys.h"
#include "vconf-internal-ise-keys.h"
#include "vconf-internal-ready-to-share-keys.h"
#include "vconf-internal-isf-keys.h"
#include "vconf-internal-shot-tizen-keys.h"
#include "vconf-internal-image-viewer-keys.h"
#include "vconf-internal-gallery-setting-keys.h"
#include "vconf-internal-popsync-keys.h"
#include "vconf-internal-livebox-keys.h"
#include "vconf-internal-pkgmgr-keys.h"
#include "vconf-internal-cluster-home-keys.h"
#include "vconf-internal-download-keys.h"
#include "vconf-internal-google-pim-sync-keys.h"
#include "vconf-internal-cloud-pdm-keys.h"
#include "vconf-internal-fmm-keys.h"
#include "vconf-internal-dailybriefing-keys.h"
#include "vconf-internal-oma-ds-keys.h"
#include "vconf-internal-aircommand-keys.h"
#include "vconf-internal-quicksetting-keys.h"
#include "vconf-internal-player-keys.h"
#include "vconf-internal-keepit-keys.h"
#include "vconf-internal-mobiletv-keys.h"
#include "vconf-internal-mdm-keys.h"
#include "vconf-internal-security-mdpp-keys.h"

#endif		/* __VCONF_INTERNAL_KEYS_H__ */
