/*
 * vconf-internal-keys
 *
 * Copyright (c) 2000 - 2011 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Contact: Hakjoo Ko <hakjoo.ko@samsung.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

#ifndef __VCONF_INTERNAL_SHOT_TIZEN_KEYS_H__
#define __VCONF_INTERNAL_SHOT_TIZEN_KEYS_H__

/**
 * This file defines keys and values.
 *
 * @file        vconf-internal-shot-tizen-keys.h
 * @defgroup    vconf_internal_shot-tizen_key Definitions of internal shared Keys for admin
 * @ingroup     vconf_internal_key
 * @author      woochan Lee <wc0917.lee@samsung.com>
 * @version     0.1
 * @brief       This file has the definitions of shared keys for shot-tizen \n
 */

/* ========================== SHOT-TIZEN Keys & Values ============================ */
/**
 * @internal
 * @addtogroup vconf_internal_shot-tizen_key
 * @{
 * @brief SHOT-TIZEN Keys & Values\n
 *        Maintainer : woochan Lee <wc0917.lee@samsung.com>
 */


/**
 * @brief The on/off status of palm touch mute for media apps sound mute enabled
 *
 * type : bool
 */
#define VCONFKEY_SHOT_TIZEN_PALM_TOUCH_MUTE_ENABLED     "db/shot-tizen/palm_touch_mute_enabled"

/**
 * @}
 */

#endif	/* __VCONF_INTERNAL_SHOT_TIZEN_KEYS_H__ */
