/*
 * vconf-internal-webkit-keys
 * Copyright (c) 2000 - 2013 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Contact: Daehyun Yoo <daehyun81.yoo@samsung.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
#ifndef __VCONF_INTERNAL_WEBKIT_KEYS_H__
#define __VCONF_INTERNAL_WEBKIT_KEYS_H__

/**
 * This file defines keys and values.
 *
 * @file        vconf-internal-webkit-keys.h
 * @defgroup    vconf_internal_webkit_key Definitions of system user agent for webkit
 * @ingroup     vconf_internal_key
 * @author      daehyun81.yoo@samsung.com
 * @version     0.1
 * @brief       This file has the definitions of system user agent for webkit \n
 */

/* ========================== Memo Keys & Values ============================ */
/**
 * @internal
 * @addtogroup vconf_internal_webkit_key
 * @{
 * @brief System User Agent Keys & Values\n
 *        Maintainer : daehyun81.yoo@samsung.com
 */

/**
 * @brief it stands system user agent for webkit
 *
 */

#define VCONFKEY_WEBKIT_USER_AGENT "db/webkit/user_agent"
/**
 * @}
 */

#endif /* __VCONF_INTERNAL_WEBKIT_KEYS_H__ */

