/*
 * context-manager
 *
 * Copyright (c) 2014 Samsung Electronics Co., Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

#ifndef __CONTEXT_EXERCISE_TYPES_H__
#define __CONTEXT_EXERCISE_TYPES_H__

#define PREFIX_EXERCISE		"exer"
#define ID_EXERCISE			PREFIX_EXERCISE"cise"
#define ID_EXERCISE_HR		PREFIX_EXERCISE".hr"

// Option Fields
#define EXERCISE_TYPE		"ExType"
#define EXERCISE_ATM		"ATM"

#define EXERCISE_CTRL_GPS	"GPS"
#define EXERCISE_CTRL_GPS_ON	1
#define EXERCISE_CTRL_GPS_OFF	0

#define EXERCISE_CTRL		"Ctrl"
#define EXERCISE_CTRL_PAUSE		0
#define EXERCISE_CTRL_RESUME	1
#define EXERCISE_CTRL_START		2
#define EXERCISE_CTRL_STOP		3

#define EXERCISE_COACHING	"Coach"
#define EXERCISE_COACHING_ON	1
#define EXERCISE_COACHING_OFF	0

// Data Fields
#define EXERCISE_GPS_STATUS	"GpsSt"

#define EXERCISE_TOTAL_DIST	"TotalDist"
#define EXERCISE_INC_DIST	"IncDist"
#define EXERCISE_DEC_DIST	"DecDist"
#define EXERCISE_FLAT_DIST	"FlatDist"
#define EXERCISE_INC_TIME	"IncTime"
#define EXERCISE_DEC_TIME	"DecTime"
#define EXERCISE_FLAT_TIME	"FlatTime"
#define EXERCISE_STANDSTILL_TIME	"StTime"
#define EXERCISE_ALTITUDE	"Alt"
#define EXERCISE_MAX_ALTITUDE	"MaxAlt"
#define EXERCISE_MIN_ALTITUDE	"MinAlt"
#define EXERCISE_SPEED		"Speed"
#define EXERCISE_MAX_SPEED	"MaxSpeed"
#define EXERCISE_AVERAGE_SPEED	"AvgSpeed"
#define EXERCISE_PACE		"Pace"
#define EXERCISE_MAX_PACE	"MaxPace"
#define EXERCISE_AVERAGE_PACE	"AvgPace"
#define EXERCISE_CALORIE	"Cal"
#define EXERCISE_STEP_COUNT	"StepCnt"
#define EXERCISE_DATA_PROVIDER	"Prvd"

#define EXERCISE_LOC_COUNT		"LocCnt"
#define EXERCISE_LOC_LATITUDE	"LocLat"
#define EXERCISE_LOC_LONGITUDE	"LocLong"
#define EXERCISE_LOC_ALTITUDE	"LocAlt"
#define EXERCISE_LOC_SPEED		"LocSpeed"
#define EXERCISE_LOC_ELAPSED_TIME	"LocElaps"

#endif	/* __CONTEXT_EXERCISE_TYPES_H__ */
