/*
 * vconf-internal-keys
 * Copyright (c) 2000 - 2011 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Contact: Zhibin Zhou <zhibin.zhou@samsung.com>, Wei Hua <wei2012.hua@samsung.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
#ifndef __VCONF_INTERNAL_MEMO_KEYS_H__
#define __VCONF_INTERNAL_MEMO_KEYS_H__

/**
 * This file defines keys and values.
 *
 * @file        vconf-internal-memo-keys.h
 * @defgroup    vconf_internal_memo_key Definitions of internal shared Keys for Memo
 * @ingroup     vconf_internal_key
 * @author      wei2012.hua@samsung.com
 * @version     0.1
 * @brief       This file has the definitions of shared keys for Alarm \n
 */

/* ========================== Memo Keys & Values ============================ */
/**
 * @internal
 * @addtogroup vconf_internal_memo_key
 * @{
 * @brief Memo Keys & Values\n
 *        Maintainer : wei2012.hua@samsung.com
 */

/**
 * @brief it stands for whether the db of memo has been changed.
 *
 */

#define VCONFKEY_MEMO_DATA_CHANGE "db/memo/data-change"
/**
 * @}
 */

#endif /* __VCONF_INTERNAL_MEMO_KEYS_H__ */

