/*
 * vconf-internal-keys
 *
 * Copyright (c) 2000 - 2011 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Contact: junsuk oh <junsuk77.oh@samsung.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

#ifndef __VCONF_INTERNAL_PKGMGR_KEYS_H__
#define __VCONF_INTERNAL_PKGMGR_KEYS_H__

/**
 * This file defines keys and values.
 *
 * @file        vconf-internal-pkgmgr-keys.h
 * @defgroup    vconf_internal_pkgmgr_key Definitions of internal shared Keys for pkgmgr
 * @ingroup     vconf_internal_key
 * @author      junsuk77.oh@samsung.com
 * @version     0.1
 * @brief       This file has the definitions of shared keys for pkgmgr \n
 */

/* ========================== PKGMGR Keys & Values ============================ */
/**
 * @internal
 * @addtogroup vconf_internal_pkgmgr_key
 * @{
 * @brief pkgmgr Keys & Values\n
 *        Maintainer : junsuk77.oh@samsung.com
 */

/**
 * @brief it stands for status of pkgmgr value.
 *
 */
#define VCONFKEY_PKGMGR_STATUS	"memory/pkgmgr/status"

/**
 * @}
 */

#endif	/* __VCONF_INTERNAL_PKGMGR_KEYS_H__ */

