/*
 * vconf-internal-keys
 * Copyright (c) 2000 - 2011 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Contact: Janani K <janani.k@samsung.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
#ifndef __VCONF_INTERNAL_MOBILETV_KEYS_H__
#define __VCONF_INTERNAL_MOBILETV_KEYS_H__

/**
 * This file defines keys and values.
 *
 * @file        vconf-internal-mobiletv-keys.h
 * @defgroup    vconf_internal_mobiletv_key Definitions of internal shared Keys for MobileTV
 * @ingroup     vconf_internal_key
 * @author      janani.k@samsung.com
 * @version     0.1
 * @brief       This file has the definitions of shared keys for MobileTV \n
 */

/* ========================== Memo Keys & Values ============================ */
/**
 * @internal
 * @addtogroup vconf_internal_mobiletv_key
 * @{
 * @brief MobileTV Keys & Values\n
 *        Maintainer : janani.k@samsung.com
 */

/**
 * @brief it stands for whether the MobileTV app is launched or not
 *
 */

#define VCONFKEY_MOBILETV_APP_LAUNCHED "db/com.samsung.mobiletv/vconf_app_launch"
/**
 * @}
 */

#endif /* __VCONF_INTERNAL_MOBILETV_KEYS_H__ */

