/*
 * libcore-context-manager
 *
 * Copyright (c) 2014 Samsung Electronics Co., Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

/**
 * @internal
 * @addtogroup	CAPI_CONTEXT_GESTURE_MODULE
 * @{
 */

#ifndef __TIZEN_CONTEXT_MOTION_H__
#define __TIZEN_CONTEXT_MOTION_H__

#include <gesture_recognition.h>

#define context_error_e			gesture_error_e

#define CONTEXT_ERROR_NONE				GESTURE_ERROR_NONE
#define CONTEXT_ERROR_INVALID_PARAMETER	GESTURE_ERROR_INVALID_PARAMETER
#define CONTEXT_ERROR_INVALID_OPERATION	GESTURE_ERROR_INVALID_OPERATION
#define CONTEXT_ERROR_OUT_OF_MEMORY		GESTURE_ERROR_OUT_OF_MEMORY
#define CONTEXT_ERROR_PERMISSION_DENIED	GESTURE_ERROR_PERMISSION_DENIED
#define CONTEXT_ERROR_ALREADY_STARTED	GESTURE_ERROR_ALREADY_STARTED
#define CONTEXT_ERROR_NOT_STARTED		GESTURE_ERROR_NOT_STARTED
#define CONTEXT_ERROR_NOT_SUPPORTED		GESTURE_ERROR_NOT_SUPPORTED
#define CONTEXT_ERROR_OPERATION_FAILED	GESTURE_ERROR_OPERATION_FAILED

#define context_motion_h		gesture_h
#define context_motion_data		gesture_data_h
#define context_motion_cb		gesture_recognition_cb
#define context_motion_type_e	gesture_type_e
#define context_motion_option_e	gesture_option_e

#define CONTEXT_MOTION_APPROACH		-1
#define CONTEXT_MOTION_WRIST_UP		-1
#define CONTEXT_MOTION_DOUBLE_TAP	GESTURE_DOUBLE_TAP
#define CONTEXT_MOTION_MOVE_TO_EAR	GESTURE_MOVE_TO_EAR
#define CONTEXT_MOTION_NO_MOVE		GESTURE_NO_MOVE
#define CONTEXT_MOTION_PICK_UP		GESTURE_PICK_UP
#define CONTEXT_MOTION_SHAKE		GESTURE_SHAKE
#define CONTEXT_MOTION_SNAP			GESTURE_SNAP
#define CONTEXT_MOTION_TILT			GESTURE_TILT
#define CONTEXT_MOTION_TURN_FACE_DOWN	GESTURE_TURN_FACE_DOWN

#define CONTEXT_MOTION_OPTION_DEFAULT	GESTURE_OPTION_DEFAULT
#define CONTEXT_MOTION_OPTION_ALWAYS_ON	GESTURE_OPTION_ALWAYS_ON

#define CONTEXT_MOTION_EVENT_NONE		GESTURE_EVENT_NONE
#define CONTEXT_MOTION_EVENT_DETECTED	GESTURE_EVENT_DETECTED

#define CONTEXT_MOTION_SHAKE_DETECTED	GESTURE_SHAKE_DETECTED
#define CONTEXT_MOTION_SHAKE_FINISHED	GESTURE_SHAKE_FINISHED

#define CONTEXT_MOTION_SNAP_X_NEGATIVE	GESTURE_SNAP_X_NEGATIVE
#define CONTEXT_MOTION_SNAP_X_POSITIVE	GESTURE_SNAP_X_POSITIVE
#define CONTEXT_MOTION_SNAP_Y_NEGATIVE	GESTURE_SNAP_Y_NEGATIVE
#define CONTEXT_MOTION_SNAP_Y_POSITIVE	GESTURE_SNAP_Y_POSITIVE
#define CONTEXT_MOTION_SNAP_Z_NEGATIVE	GESTURE_SNAP_Z_NEGATIVE
#define CONTEXT_MOTION_SNAP_Z_POSITIVE	GESTURE_SNAP_Z_POSITIVE

#define context_motion_is_supported(motion)	gesture_is_supported(motion, NULL)
#define context_motion_create		gesture_create
#define context_motion_release		gesture_release
#define context_motion_start		gesture_start_recognition
#define context_motion_stop			gesture_stop_recognition
#define context_motion_get_event(data, event)	gesture_get_event((data), (gesture_event_e*)(event));
#define context_motion_get_tilt		gesture_get_tilt

/**
* @}
*/

#endif // __TIZEN_CONTEXT_MOTION_H__
