/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.hds;

import com.google.protobuf.GeneratedMessage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.stage.DirectoryChooser;
import javafx.util.Callback;
import org.tizen.ecp.dialog.MessageBox;
import org.tizen.ecp.hds.HDSData;
import org.tizen.ecp.msg.genmsg.ecs.Ecs;
import org.tizen.ecp.resources.Images;
import org.tizen.ecp.sock.EventMgr;
import org.tizen.ecp.sock.ILsn;
import org.tizen.ecp.sock.MessageSender;
import org.tizen.ecp.string.DeviceMessages;
import org.tizen.ecp.utils.ECPFXMLLoader;
import org.tizen.ecp.utils.LogUtil;
import org.tizen.ecp.views.popup.ECPPopupPane;

public class HDSPane
extends ECPPopupPane
implements Initializable {
    private static Logger logger = LogUtil.getECPLogger(HDSPane.class).getLogger();
    private boolean isInitialize = false;
    @FXML
    private Label fxTitleLab;
    @FXML
    private TextField fxHostDirTxt;
    @FXML
    private TextField fxDestDirTxt;
    @FXML
    private Button fxBrowseBtn;
    @FXML
    private Button fxMountBtn;
    @FXML
    private Button fxUnmountBtn;
    @FXML
    private Label fxSlotDiscriptionLab;
    @FXML
    private Label fxSlotValueLab;
    @FXML
    private TableView<HDSData> fxHDSTable;
    @FXML
    private TableColumn<HDSData, String> fxHostDirCol;
    @FXML
    private TableColumn<HDSData, String> fxDestCol;
    @FXML
    private ObservableList<HDSData> HDSItems;
    private DirectoryChooser dirChooser;
    private final ChangeListener<String> textChanageListener = new ChangeListener<String>(){

        public void changed(ObservableValue<? extends String> observableValue, String string, String string2) {
            if (!HDSPane.this.fxHostDirTxt.getText().isEmpty() && !HDSPane.this.fxDestDirTxt.getText().isEmpty()) {
                HDSPane.this.fxMountBtn.setDisable(false);
            } else {
                HDSPane.this.fxMountBtn.setDisable(true);
            }
        }
    };
    private final ListChangeListener<Integer> tableSelectionListener = new ListChangeListener<Integer>(){

        public void onChanged(ListChangeListener.Change<? extends Integer> change) {
            ObservableList observableList = HDSPane.this.fxHDSTable.getSelectionModel().getSelectedItems();
            if (observableList.size() == 1) {
                HDSPane.this.fxUnmountBtn.setDisable(false);
            } else {
                HDSPane.this.fxUnmountBtn.setDisable(true);
            }
        }
    };
    private boolean isMount = false;

    public Pane create() {
        VBox vBox;
        try {
            URL uRL = ((Object)((Object)this)).getClass().getResource("hds.fxml");
            ECPFXMLLoader eCPFXMLLoader = new ECPFXMLLoader(uRL, new Object[0]);
            vBox = (VBox)eCPFXMLLoader.load();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return new Pane();
        }
        return vBox;
    }

    public void OnStatusEventProcPB(GeneratedMessage generatedMessage) {
        Ecs.DeviceNtf deviceNtf;
        if (!this.isInitialize) {
            return;
        }
        if (generatedMessage instanceof Ecs.DeviceNtf && 99 == (deviceNtf = (Ecs.DeviceNtf)generatedMessage).getAction()) {
            String[] stringArray;
            String string = new String(deviceNtf.getData().toByteArray());
            logger.info("HDS status is " + string);
            if (string == null || string.isEmpty()) {
                return;
            }
            this.HDSItems.clear();
            for (String string2 : stringArray = string.split("\n")) {
                this.addItem(string2);
            }
        }
    }

    public void OnEventProcPB(String string, GeneratedMessage generatedMessage) {
        Ecs.DeviceNtf deviceNtf;
        if (!this.isInitialize) {
            return;
        }
        if (generatedMessage instanceof Ecs.DeviceNtf && 100 == (deviceNtf = (Ecs.DeviceNtf)generatedMessage).getGroup()) {
            int n = deviceNtf.getAction();
            logger.info("HDS NTF action: " + n);
            String string2 = new String(deviceNtf.getData().toByteArray());
            if (string2 == null || string2.isEmpty()) {
                logger.severe("data is empty.");
                return;
            }
            switch (n) {
                case 98: {
                    logger.info("Available PCI slot: " + string2);
                    if (!this.isSlotLabelVisible()) {
                        this.setSlotLabelVisible(true);
                    }
                    this.setPCISlotInfo(string2);
                    break;
                }
                case 1: {
                    this.addItem(string2);
                    if (this.isSlotLabelVisible()) {
                        this.setPCISlotInfo(false);
                    }
                    this.fxHostDirTxt.setText("");
                    this.fxDestDirTxt.setText("");
                    break;
                }
                case 2: {
                    MessageBox.error((String)(DeviceMessages.getString("HDSDisplay.24") + string2));
                    break;
                }
                case 11: {
                    MessageBox.error((String)(DeviceMessages.getString("HDSDisplay.25") + string2 + DeviceMessages.getString("HDSDisplay.26")));
                    break;
                }
                case 12: {
                    MessageBox.error((String)(DeviceMessages.getString("HDSDisplay.27") + string2 + DeviceMessages.getString("HDSDisplay.28")));
                    break;
                }
                case 3: {
                    logger.info("unmount success: " + string2);
                    if (this.isSlotLabelVisible()) {
                        this.setPCISlotInfo(true);
                    }
                    this.removeItem(string2);
                    break;
                }
                case 4: {
                    MessageBox.error((String)(DeviceMessages.getString("HDSDisplay.30") + string2));
                    break;
                }
                case 5: {
                    MessageBox.error((String)(DeviceMessages.getString("HDSDisplay.31") + string2));
                    break;
                }
                case 31: {
                    MessageBox.error((String)(DeviceMessages.getString("HDSDisplay.32") + string2));
                    break;
                }
                default: {
                    logger.info("HDS unknown action notification: " + n);
                }
            }
        }
    }

    public void initialize(URL uRL, ResourceBundle resourceBundle) {
        this.fxTitleLab.getStyleClass().add((Object)"titleLabel");
        ImageView imageView = Images.getImageView((String)"Common", (String)"btn_ic_path.png");
        if (imageView != null) {
            this.fxBrowseBtn.setText("");
            this.fxBrowseBtn.setGraphic((Node)imageView);
        } else {
            this.fxBrowseBtn.setText("...");
        }
        this.fxHostDirTxt.setEditable(false);
        this.HDSItems = this.fxHDSTable.getItems();
        this.fxHDSTable.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        this.fxHDSTable.getSelectionModel().getSelectedIndices().addListener(this.tableSelectionListener);
        this.fxDestCol.setCellValueFactory((Callback)new PropertyValueFactory("guestPath"));
        this.fxHostDirCol.setCellValueFactory((Callback)new PropertyValueFactory("hostPath"));
        this.fxHostDirTxt.textProperty().addListener(this.textChanageListener);
        this.fxDestDirTxt.textProperty().addListener(this.textChanageListener);
        this.fxMountBtn.setDisable(true);
        this.fxUnmountBtn.setDisable(true);
        this.setSlotLabelVisible(false);
        this.isInitialize = true;
        EventMgr.getInstance().AddLsn("hds", (ILsn)this);
        this.sendHDSMessage(15, 99);
    }

    @FXML
    public void onClickBrowseBtn(ActionEvent actionEvent) {
        File file;
        if (this.dirChooser == null) {
            this.dirChooser = new DirectoryChooser();
        }
        if ((file = this.dirChooser.showDialog(null)) != null) {
            this.fxHostDirTxt.setText(file.getAbsolutePath());
        }
    }

    @FXML
    public void onClickMountBtn(ActionEvent actionEvent) {
        if (this.isMount) {
            return;
        }
        this.isMount = true;
        if (this.validateHost(this.fxHostDirTxt.getText()) && this.validateDest(this.fxDestDirTxt.getText()) && this.validatePCI(this.fxSlotValueLab.getText())) {
            this.doMount();
        }
        this.isMount = false;
    }

    @FXML
    public void onClickUnmountBtn(ActionEvent actionEvent) {
        this.doUnMount();
    }

    private void sendHDSMessage(int n, int n2) {
        this.sendHDSMessage(n, n2, "");
    }

    private void sendHDSMessage(int n, int n2, String string) {
        MessageSender.getInstance().sendDeviceReq("hds", n, n2, string);
    }

    private void doMount() {
        String string = this.fxHostDirTxt.getText() + "\n" + "/mnt/" + this.fxDestDirTxt.getText() + "\n" + 0 + "\n";
        logger.info("send mount message: " + string);
        this.sendHDSMessage(100, 1, string);
    }

    private void doUnMount() {
        HDSData hDSData = (HDSData)this.fxHDSTable.getSelectionModel().getSelectedItem();
        String string = hDSData.getTag();
        logger.info("send unmount with tag: " + string);
        String string2 = string + "\n" + 0 + "\n";
        this.sendHDSMessage(100, 2, string2);
    }

    private boolean isSlotLabelVisible() {
        return this.fxSlotDiscriptionLab.isVisible();
    }

    private void setSlotLabelVisible(boolean bl) {
        this.fxSlotDiscriptionLab.setVisible(bl);
        this.fxSlotValueLab.setVisible(bl);
    }

    private void setPCISlotInfo(String string, boolean bl, boolean bl2) {
        int n;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            logger.severe("PCI slot info - not a number: " + string);
            return;
        }
        if (bl) {
            if (bl2 && n < 32) {
                ++n;
            } else if (!bl2 && n > 0) {
                --n;
            }
        }
        this.fxSlotValueLab.setText("" + n);
    }

    private void setPCISlotInfo(String string) {
        this.setPCISlotInfo(string, false, false);
    }

    private void setPCISlotInfo(boolean bl) {
        String string = this.fxSlotValueLab.getText();
        this.setPCISlotInfo(string, true, bl);
    }

    private void addItem(String string) {
        boolean bl = false;
        String string2 = "";
        String[] stringArray = string.split(",");
        if (stringArray.length == 4) {
            bl = true;
        } else if (stringArray.length == 3) {
            logger.info("This version is used for backward compatibility.");
        } else {
            logger.severe("hds list wrong format: " + string);
            return;
        }
        String string3 = stringArray[0];
        String string4 = stringArray[1];
        String string5 = stringArray[2];
        if (bl) {
            string2 = stringArray[3];
        }
        if (this.checkDuplicate(string3)) {
            logger.info(string3 + " is duplicated. skip!");
            return;
        }
        if (bl && this.checkHidden(string2)) {
            logger.info(string3 + " is hidden. skip!");
            return;
        }
        HDSData hDSData = new HDSData();
        hDSData.setGuestPath(string5);
        hDSData.setHostPath(string4);
        hDSData.setTag(string3);
        this.HDSItems.add((Object)hDSData);
    }

    private void removeItem(String string) {
        int n = -1;
        for (HDSData hDSData : this.HDSItems) {
            if (!hDSData.getTag().equals(string)) continue;
            logger.info("removeItem -found the target item: " + string);
            n = this.HDSItems.indexOf((Object)hDSData);
            if (n != -1) continue;
            logger.severe("Unpredictable error occurs. Lost the target item.");
            return;
        }
        this.HDSItems.remove(n);
    }

    private boolean checkDuplicate(String string) {
        for (HDSData hDSData : this.HDSItems) {
            if (!hDSData.getTag().equals(string)) continue;
            return true;
        }
        return false;
    }

    private boolean checkHidden(String string) {
        return "1".equals(string);
    }

    private boolean validateHost(String string) {
        if (string.isEmpty()) {
            MessageBox.error((String)DeviceMessages.getString("HDSDisplay.13"));
            return false;
        }
        File file = new File(string);
        if (!file.exists() || !file.isDirectory()) {
            MessageBox.error((String)DeviceMessages.getString("HDSDisplay.13"));
            return false;
        }
        for (HDSData hDSData : this.HDSItems) {
            String string2 = hDSData.getHostPath();
            if (!string2.equals(string)) continue;
            MessageBox.error((String)DeviceMessages.getString("HDSDisplay.14"));
            return false;
        }
        return true;
    }

    private boolean validateDest(String string) {
        if (string.isEmpty()) {
            MessageBox.error((String)DeviceMessages.getString("HDSDisplay.15"));
            return false;
        }
        for (HDSData hDSData : this.HDSItems) {
            String string2 = hDSData.getGuestPath();
            if (!string2.equals("/mnt/" + string)) continue;
            MessageBox.error((String)DeviceMessages.getString("HDSDisplay.16"));
            return false;
        }
        return true;
    }

    private boolean validatePCI(String string) {
        int n;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            logger.severe("validatePCI - not a number: " + string);
            return false;
        }
        if (n == 0) {
            MessageBox.error((String)DeviceMessages.getString("HDSDisplay.33"));
            return false;
        }
        return true;
    }
}

