/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.hds;

import com.google.protobuf.GeneratedMessage;
import java.util.logging.Logger;
import org.kohsuke.args4j.Argument;
import org.tizen.cli.AbstractEmulatorCLI;
import org.tizen.cli.utils.OutputUtil;
import org.tizen.ecp.msg.genmsg.ecs.Ecs;
import org.tizen.ecp.sock.MessageSender;
import org.tizen.ecp.string.DeviceMessages;
import org.tizen.ecp.utils.LogUtil;

public class HDSUmountCLI
extends AbstractEmulatorCLI {
    private static Logger logger = LogUtil.getECPLogger(HDSUmountCLI.class).getLogger();
    @Argument(index=0, required=true)
    String id;
    @Argument(index=1, required=false)
    String hidden;

    public HDSUmountCLI() {
        this.messageType = "hds";
    }

    public int execute() {
        int n = 0;
        if (this.id == null || this.id.isEmpty()) {
            OutputUtil.printHelpError((String)DeviceMessages.getString("HDSUmountCLI.1"), (String)this.help);
            return 25;
        }
        if (this.hidden != null && "hidden".equals(this.hidden)) {
            n = 1;
        }
        String string = this.id + "\n" + n + "\n";
        MessageSender.getInstance().sendDeviceReq(this.messageType, 100, 2, string);
        this.startRunning();
        return 0;
    }

    public void OnEventProcPB(String string, GeneratedMessage generatedMessage) {
        Ecs.DeviceNtf deviceNtf;
        if (generatedMessage instanceof Ecs.DeviceNtf && 100 == (deviceNtf = (Ecs.DeviceNtf)generatedMessage).getGroup()) {
            int n = deviceNtf.getAction();
            logger.info("HDSUmountCLI action: " + n);
            switch (n) {
                case 3: {
                    OutputUtil.printOK();
                    this.stopRunning();
                    return;
                }
                case 4: {
                    OutputUtil.printError((String)DeviceMessages.getString("HDSDisplay.30"));
                    break;
                }
                case 5: {
                    OutputUtil.printError((String)DeviceMessages.getString("HDSDisplay.31"));
                    break;
                }
                case 31: {
                    OutputUtil.printError((String)DeviceMessages.getString("HDSDisplay.32"));
                    break;
                }
                default: {
                    logger.info("HDSMountCLI unknown action notification: " + n);
                }
            }
            this.returnValue = 128;
            this.stopRunning();
        }
    }
}

