/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.rssi;

import java.net.URL;
import java.util.ResourceBundle;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import org.tizen.ecp.dialog.MessageBox;
import org.tizen.ecp.legacy.InjectorMessage;
import org.tizen.ecp.resources.Images;
import org.tizen.ecp.rssi.RSSISignalImage;
import org.tizen.ecp.sock.MessageSender;

public class RSSIController
implements Initializable {
    @FXML
    ImageView fx_rssi_img;
    @FXML
    TextField fx_level_textfield;
    Image lv0_img;
    Image lv1_img;
    Image lv2_img;
    Image lv3_img;
    Image lv4_img;

    public void initialize(URL uRL, ResourceBundle resourceBundle) {
        this.lv0_img = Images.getImage((String)"RSSI", (String)RSSISignalImage.LV0.getImg());
        this.lv1_img = Images.getImage((String)"RSSI", (String)RSSISignalImage.LV1.getImg());
        this.lv2_img = Images.getImage((String)"RSSI", (String)RSSISignalImage.LV2.getImg());
        this.lv3_img = Images.getImage((String)"RSSI", (String)RSSISignalImage.LV3.getImg());
        this.lv4_img = Images.getImage((String)"RSSI", (String)RSSISignalImage.LV4.getImg());
        this.fx_rssi_img.setImage(this.lv0_img);
    }

    public void setLevel(String string) {
        this.fx_level_textfield.setText(string);
        int n = Integer.valueOf(string);
        switch (n) {
            case 0: {
                this.fx_rssi_img.setImage(this.lv0_img);
                break;
            }
            case 1: {
                this.fx_rssi_img.setImage(this.lv1_img);
                break;
            }
            case 2: {
                this.fx_rssi_img.setImage(this.lv2_img);
                break;
            }
            case 3: {
                this.fx_rssi_img.setImage(this.lv3_img);
                break;
            }
            case 4: {
                this.fx_rssi_img.setImage(this.lv4_img);
            }
        }
    }

    public void send(int n) {
        InjectorMessage injectorMessage = new InjectorMessage(n);
        MessageSender.getInstance().sendInjectorReq("sensor", 0, 0, "11\n" + injectorMessage.getMessage());
        MessageSender.getInstance().sendInjectorReq("telephony", 19, n);
    }

    @FXML
    public void onTextChanged(ActionEvent actionEvent) {
        String string = this.fx_level_textfield.getText();
        if (string.matches("[0-4]")) {
            this.setLevel(string);
            this.send(Integer.valueOf(string));
        } else {
            actionEvent.consume();
            MessageBox.error((String)"Please type the rssi level from 0 to 4.");
        }
    }

    @FXML
    public void onMouseClicked(MouseEvent mouseEvent) {
        double d = 0.0;
        double d2 = 0.0;
        d = mouseEvent.getX();
        RSSISignalImage rSSISignalImage = RSSISignalImage.getRSSISignalImage((int)d, (int)(d2 = mouseEvent.getY()));
        if (rSSISignalImage != null) {
            this.setLevel(String.valueOf(rSSISignalImage.getLevel()));
            this.send(rSSISignalImage.getLevel());
        }
    }
}

