/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.sdcard;

import com.google.protobuf.GeneratedMessage;
import org.kohsuke.args4j.Argument;
import org.tizen.cli.AbstractEmulatorCLI;
import org.tizen.cli.utils.OutputUtil;
import org.tizen.ecp.msg.genmsg.ecs.Ecs;
import org.tizen.ecp.sdcard.SDCardAttachHelper;
import org.tizen.ecp.string.DeviceMessages;

public class SDCardDetachCLI
extends AbstractEmulatorCLI {
    private String TYPE_SDCARD;
    @Argument(index=0, metaVar="sdcard_4G.img sdcard_8G.img sdcard_16G.img sdcard_32G.img")
    String card;

    public SDCardDetachCLI() {
        this.messageType = this.TYPE_SDCARD = "sdcard";
    }

    public void printHelp() {
        super.printHelp();
    }

    public int execute() {
        if (this.card == null) {
            OutputUtil.printError((String)DeviceMessages.getString("SDCardDetachCLI.1"));
            this.printHelp();
            return 25;
        }
        if (!(this.card.toLowerCase().equals("sdcard_4G.img".toLowerCase()) || this.card.toLowerCase().equals("sdcard_8G.img".toLowerCase()) || this.card.toLowerCase().equals("sdcard_16G.img".toLowerCase()) || this.card.toLowerCase().equals("sdcard_32G.img".toLowerCase()))) {
            OutputUtil.println((String)("'" + this.card + DeviceMessages.getString("SDCardDetachCLI.3")));
            OutputUtil.println((String)this.help);
            return 25;
        }
        SDCardAttachHelper.getInstance().sendSDcard("0\n" + this.card + "\n");
        this.startRunning();
        return 0;
    }

    public void OnEventProcPB(String string, GeneratedMessage generatedMessage) {
        if (!(generatedMessage instanceof Ecs.DeviceNtf)) {
            return;
        }
        Ecs.DeviceNtf deviceNtf = (Ecs.DeviceNtf)generatedMessage;
        long l = deviceNtf.getGroup();
        long l2 = deviceNtf.getAction();
        if (l == 11L) {
            if (l2 == 0L) {
                OutputUtil.printOK();
                this.stopRunning();
            } else if (l2 == 4L) {
                this.returnValue = 128;
                OutputUtil.printError((String)(DeviceMessages.getString("SDCardDetachCLI.6") + DeviceMessages.getString("SDCardDetachCLI.7")));
                this.stopRunning();
            } else if (l2 == 6L) {
                this.returnValue = 128;
                OutputUtil.printError((String)(DeviceMessages.getString("SDCardDetachCLI.8") + this.card + DeviceMessages.getString("SDCardDetachCLI.9")));
                this.stopRunning();
            }
        }
    }
}

