/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.sensor;

import java.io.File;
import org.kohsuke.args4j.Argument;
import org.tizen.cli.AbstractEmulatorCLI;
import org.tizen.cli.utils.OutputUtil;
import org.tizen.ecp.string.DeviceMessages;

public class SensorFileCLI
extends AbstractEmulatorCLI {
    private static final String ACCEL = DeviceMessages.getString("SensorFileCLI.0");
    private static final String GYRO = DeviceMessages.getString("SensorFileCLI.1");
    private static final String GEO = DeviceMessages.getString("SensorFileCLI.2");
    @Argument(required=true, index=0, metaVar="accelerometer gyroscope magnetic")
    String sensor;
    @Argument(required=true, index=1)
    String path1;

    private int filePathValidation(String string) {
        if (this.path1 == null) {
            OutputUtil.printError((String)DeviceMessages.getString("SensorFileCLI.3"));
            this.printHelp();
            return 25;
        }
        File file = new File(this.path1);
        if (!file.exists()) {
            OutputUtil.printError((String)(DeviceMessages.getString("SensorFileCLI.4") + this.path1));
            this.printHelp();
            return 25;
        }
        return 0;
    }

    public int execute() {
        int n = 0;
        boolean bl = false;
        if (this.sensor == null || !ACCEL.equals(this.sensor) && !GYRO.equals(this.sensor) && !GEO.equals(this.sensor)) {
            OutputUtil.printError((String)(DeviceMessages.getString("SensorFileCLI.5") + ACCEL + ", " + GYRO + DeviceMessages.getString("SensorFileCLI.7") + GEO + ")"));
            this.printHelp();
            return 25;
        }
        n = this.filePathValidation(this.path1);
        if (n != 0) {
            return n;
        }
        if (!bl) {
            OutputUtil.printFail();
            return 128;
        }
        OutputUtil.printOK();
        return 0;
    }
}

