/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.sensor.geo;

import java.net.URL;
import java.text.DecimalFormat;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.scene.control.Slider;
import javafx.scene.control.TextField;
import org.tizen.ecp.control.TizenTextField;
import org.tizen.ecp.dialog.MessageBox;
import org.tizen.ecp.legacy.InjectorMessage;
import org.tizen.ecp.sensor.accelerometer.AccConstants;
import org.tizen.ecp.sensor.fxml.FXMLSensorViewController;
import org.tizen.ecp.sensor.fxml.SliderChangeListener;
import org.tizen.ecp.sensor.geo.GeoFileOperation;
import org.tizen.ecp.sock.MessageSender;

public class MagneticViewController
extends FXMLSensorViewController {
    private DecimalFormat df = new DecimalFormat("0");

    public void initialize(URL uRL, ResourceBundle resourceBundle) {
        this.initialize();
        this.fxNameLab.setText("Magnetic");
        this.fxXTxt.setMaxLen(8);
        this.fxYTxt.setMaxLen(8);
        this.fxZTxt.setMaxLen(8);
        this.fxXUnitLab.setText("[\u00b5T]");
        this.fxYUnitLab.setText("[\u00b5T]");
        this.fxZUnitLab.setText("[\u00b5T]");
        this.createSlider(this.fxXSlider);
        this.createSlider(this.fxYSlider);
        this.createSlider(this.fxZSlider);
        this.fxXTxt.setText(this.df.format(this.fxXSlider.getValue()));
        this.fxYTxt.setText(this.df.format(this.fxYSlider.getValue()));
        this.fxZTxt.setText(this.df.format(this.fxZSlider.getValue()));
        this.setFileOperation(new GeoFileOperation());
        this.addListener();
    }

    private void addListener() {
        this.fxXSlider.valueProperty().addListener((ChangeListener)new SliderChangeListener((TextField)this.fxXTxt, this.df));
        this.fxYSlider.valueProperty().addListener((ChangeListener)new SliderChangeListener((TextField)this.fxYTxt, this.df));
        this.fxZSlider.valueProperty().addListener((ChangeListener)new SliderChangeListener((TextField)this.fxZTxt, this.df));
    }

    @Override
    protected void onEnterToTextField(TizenTextField tizenTextField, Slider slider) {
        String string = tizenTextField.getText();
        try {
            Integer n = Integer.parseInt(string);
            if (n < -2000 || n > 2000) {
                throw new Exception();
            }
            slider.setValue((double)n.intValue());
        }
        catch (Exception exception) {
            String string2 = AccConstants.INFO_RANGE_OUT_BEGIN + -2000 + AccConstants.INFO_RANGE_OUT_TO + 2000 + ".";
            MessageBox.error((String)"Emulator Control Panel", (String)string2);
            tizenTextField.setText(this.df.format(slider.getValue()));
            return;
        }
    }

    private void createSlider(Slider slider) {
        slider.setMin(-2000.0);
        slider.setMax(2000.0);
        slider.setValue(0.0);
    }

    @Override
    public void sendMessage() {
        int n = (int)this.fxXSlider.getValue();
        int n2 = (int)this.fxYSlider.getValue();
        int n3 = (int)this.fxZSlider.getValue();
        InjectorMessage injectorMessage = new InjectorMessage((double)n, (double)n2, (double)n3);
        MessageSender.getInstance().sendDeviceReq("sensor", 0, 0, "13\n" + injectorMessage.getMessage());
    }

    @Override
    public void setStatus(String string) {
        if (string == null || string.isEmpty()) {
            return;
        }
        String[] stringArray = string.split(" ");
        int n = Integer.parseInt(stringArray[0]);
        int n2 = Integer.parseInt(stringArray[1]);
        int n3 = Integer.parseInt(stringArray[2]);
        this.fxXSlider.setValue((double)n);
        this.fxYSlider.setValue((double)n2);
        this.fxZSlider.setValue((double)n3);
    }
}

