/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.earjack;

import com.google.protobuf.GeneratedMessage;
import org.kohsuke.args4j.Argument;
import org.tizen.cli.AbstractEmulatorCLI;
import org.tizen.cli.utils.OutputUtil;
import org.tizen.ecp.legacy.InjectorMessage;
import org.tizen.ecp.msg.genmsg.ecs.Ecs;
import org.tizen.ecp.sock.MessageSender;
import org.tizen.ecp.string.DeviceMessages;

public class EarJackSetCLI
extends AbstractEmulatorCLI {
    private String TYPE_SENSOR;
    @Argument(required=true, metaVar="3wire 4wire off")
    String mode;

    public EarJackSetCLI() {
        this.messageType = this.TYPE_SENSOR = DeviceMessages.getString("EarJackSetCLI.0");
    }

    public void printHelp() {
        OutputUtil.print((String)this.help);
    }

    public int execute() {
        int n = 0;
        if (this.mode == null) {
            OutputUtil.printError((String)DeviceMessages.getString("EarJackSetCLI.1"));
            this.printHelp();
            return 25;
        }
        if (this.mode.toLowerCase().equals("3wire")) {
            n = 1;
        } else if (this.mode.toLowerCase().equals("4wire")) {
            n = 3;
        } else if (this.mode.toLowerCase().equals("off")) {
            n = 0;
        } else {
            OutputUtil.printError((String)("'" + this.mode + DeviceMessages.getString("EarJackSetCLI.6")));
            OutputUtil.println((String)this.help);
            return 25;
        }
        InjectorMessage injectorMessage = new InjectorMessage(n);
        MessageSender.getInstance().sendInjectorReq(this.TYPE_SENSOR, 0, 0, "9\n" + injectorMessage.getMessage());
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            OutputUtil.printError((String)DeviceMessages.getString("EarJackSetCLI.7"), (Exception)interruptedException);
        }
        MessageSender.getInstance().sendInjectorReq("sensor", 15, 103);
        this.startRunning();
        if (this.returnValue == 128) {
            OutputUtil.printFail();
        } else {
            OutputUtil.printOK();
        }
        return 0;
    }

    public void OnEventProcPB(String string, GeneratedMessage generatedMessage) {
        if (generatedMessage instanceof Ecs.InjectorAns) {
            Ecs.InjectorAns injectorAns = (Ecs.InjectorAns)generatedMessage;
            int n = injectorAns.getErrcode();
            if (n != 0) {
                this.returnValue = 128;
            }
            this.stopRunning();
        }
    }
}

