/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.memory;

import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.GridPane;
import org.tizen.ecp.control.TizenRadioButton;
import org.tizen.ecp.memory.MemoryModel;
import org.tizen.ecp.sock.MessageSender;

public class MemoryController
implements Initializable {
    @FXML
    public GridPane memoryGrid;
    private TizenRadioButton hWarn;
    private TizenRadioButton sWarn;
    private TizenRadioButton normal;
    private MemoryModel model;
    ChangeListener<Number> statusChangeListener = new ChangeListener<Number>(){

        public void changed(ObservableValue<? extends Number> observableValue, Number number, Number number2) {
            if (number2.intValue() == 4) {
                MemoryController.this.hWarn.setSelected(true);
            } else if (number2.intValue() == 2) {
                MemoryController.this.sWarn.setSelected(true);
            } else if (number2.intValue() == 1) {
                MemoryController.this.normal.setSelected(true);
            }
        }
    };
    ChangeListener<Toggle> toggleChangeListener = new ChangeListener<Toggle>(){

        public void changed(ObservableValue<? extends Toggle> observableValue, Toggle toggle, Toggle toggle2) {
            int n = -1;
            if (toggle == null) {
                return;
            }
            if (toggle2.equals(MemoryController.this.hWarn)) {
                n = 4;
            } else if (toggle2.equals(MemoryController.this.sWarn)) {
                n = 2;
            } else if (toggle2.equals(MemoryController.this.normal)) {
                n = 1;
            }
            MemoryController.this.model.setStatus(n);
            MemoryController.this.send(n);
        }
    };

    public MemoryController(MemoryModel memoryModel) {
        this.model = memoryModel;
    }

    public void initialize(URL uRL, ResourceBundle resourceBundle) {
        ToggleGroup toggleGroup = new ToggleGroup();
        toggleGroup.selectedToggleProperty().addListener(this.toggleChangeListener);
        this.hWarn = this.model.getHardWarn();
        this.hWarn.setHgap(18.0);
        this.hWarn.setToggleGroup(toggleGroup);
        this.memoryGrid.add((Node)this.hWarn, 1, 1, 4, 1);
        this.sWarn = this.model.getSoftWarn();
        this.sWarn.setHgap(18.0);
        this.sWarn.setToggleGroup(toggleGroup);
        this.memoryGrid.add((Node)this.sWarn, 1, 3, 4, 1);
        this.normal = this.model.getNormal();
        this.normal.setHgap(18.0);
        this.normal.setToggleGroup(toggleGroup);
        this.memoryGrid.add((Node)this.normal, 1, 5, 4, 1);
        this.model.getStatus().addListener(this.statusChangeListener);
    }

    public void send(int n) {
        MessageSender.getInstance().sendInjectorReq("vconf", 30, 1, "int\nmemory/sysman/low_memory\n" + n + "\n");
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        MessageSender.getInstance().sendInjectorReq("vconf", 30, 0, "int\nmemory/sysman/low_memory\n\n");
    }
}

