/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.nfc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import org.tizen.ecp.dialog.MessageBox;
import org.tizen.ecp.nfc.MimeTypeList;
import org.tizen.ecp.nfc.NDEFRecord;
import org.tizen.ecp.nfc.NFCDialog;
import org.tizen.ecp.nfc.NFCErrorString;
import org.tizen.ecp.sdb.IShellOutputReceiver;
import org.tizen.ecp.sdb.MultiLineReceiver;
import org.tizen.ecp.sdb.SDBCommandRejectedException;
import org.tizen.ecp.sdb.SDBHelperUtil;
import org.tizen.ecp.sdb.SDBNotExistException;
import org.tizen.ecp.sock.MessageSender;
import org.tizen.ecp.string.ApplicationConstants;
import org.tizen.ecp.string.DeviceMessages;
import org.tizen.ecp.utils.LogUtil;

public class NFCHelpProcess {
    private static Logger logger = LogUtil.getECPLogger(NFCHelpProcess.class).getLogger();
    private String shellCmd = null;
    private String shellResult = null;

    public boolean checkInvalidCharaters(String string) {
        char[] cArray = new char[1000];
        string.getChars(0, string.length(), cArray, 0);
        for (int i = 0; i < string.length(); ++i) {
            char c = cArray[i];
            if (c == '\n') {
                this.openInfoDialog(NFCErrorString.InvalidCharNewLine);
                return false;
            }
            if (c == ',') {
                this.openInfoDialog(NFCErrorString.InvalidChar);
                return false;
            }
            if (c < '\u0080') continue;
            this.openInfoDialog(NFCErrorString.InvalidCharAscii);
            return false;
        }
        return true;
    }

    private void openInfoDialog(String string) {
        MessageBox.confirm((String)DeviceMessages.getString("NFCDialog.0"), (String)string);
    }

    public int checkRecordlistMaxLength(ArrayList<NDEFRecord> arrayList, int n) {
        int n2 = 0;
        for (NDEFRecord nDEFRecord : arrayList) {
            n2 += 1 + nDEFRecord.getTypeName().length() + nDEFRecord.getId().length() + nDEFRecord.getPayload().length() + 4;
        }
        if (n2 > n) {
            this.openInfoDialog(DeviceMessages.getString("NFCHelpProcess.0") + n + DeviceMessages.getString("NFCHelpProcess.1"));
            return 0;
        }
        return n2;
    }

    static String checkFileType(String string) {
        int n = string.lastIndexOf(46);
        String string2 = null;
        if (n != -1) {
            String string3 = string.substring(n + 1);
            MimeTypeList mimeTypeList = MimeTypeList.getInstance();
            string2 = mimeTypeList.findMimeType(string3);
        }
        return string2;
    }

    static boolean checkFileSize(String string) {
        boolean bl = false;
        String string2 = "du " + string;
        final StringBuilder stringBuilder = new StringBuilder();
        MultiLineReceiver multiLineReceiver = new MultiLineReceiver(){

            public void processNewLines(String[] stringArray) {
                stringBuilder.append(stringArray[0]);
            }
        };
        try {
            SDBHelperUtil.getInstance().executeShellCommand(string2, (IShellOutputReceiver)multiLineReceiver);
        }
        catch (SDBNotExistException sDBNotExistException) {
            logger.info("SDBNotExistException: " + sDBNotExistException.getMessage());
            MessageBox.error((String)sDBNotExistException.getMessage());
            SDBHelperUtil.getInstance().closeMultiLineReceiver(multiLineReceiver);
            return bl;
        }
        catch (SDBCommandRejectedException sDBCommandRejectedException) {
            MessageBox.error((String)ApplicationConstants.EMULATOR_NOT_READY);
            SDBHelperUtil.getInstance().closeMultiLineReceiver(multiLineReceiver);
            return bl;
        }
        catch (TimeoutException timeoutException) {
            logger.info("TimeoutException: " + timeoutException.getMessage());
            SDBHelperUtil.getInstance().closeMultiLineReceiver(multiLineReceiver);
            NFCHelpProcess.errorSelectMediaFile("SDB: " + timeoutException.getMessage());
            SDBHelperUtil.getInstance().closeMultiLineReceiver(multiLineReceiver);
            return bl;
        }
        catch (IOException iOException) {
            logger.info("IOException: " + iOException.getMessage());
            SDBHelperUtil.getInstance().closeMultiLineReceiver(multiLineReceiver);
            NFCHelpProcess.errorSelectMediaFile("SDB: " + iOException.getMessage());
            SDBHelperUtil.getInstance().closeMultiLineReceiver(multiLineReceiver);
            return bl;
        }
        SDBHelperUtil.getInstance().closeMultiLineReceiver(multiLineReceiver);
        String string3 = stringBuilder.toString();
        int n = string3.indexOf(9);
        if (n != -1 && Integer.valueOf(string3 = string3.substring(0, n)) <= 10) {
            bl = true;
        }
        return bl;
    }

    private static void errorSelectMediaFile(String string) {
        NFCDialog.openErrorDialog(NFCErrorString.MediaFileException + string);
    }

    private void errorCheckVconf(String string) {
        NFCDialog.openErrorDialog(NFCErrorString.CheckVconfException + string);
    }

    private boolean checkVconfValue() {
        boolean bl = false;
        this.shellCmd = "vconftool get db/nfc/enable";
        MultiLineReceiver multiLineReceiver = new MultiLineReceiver(){

            public void processNewLines(String[] stringArray) {
                NFCHelpProcess.this.shellResult = stringArray[0];
            }
        };
        try {
            SDBHelperUtil.getInstance().executeShellRootCommand(this.shellCmd, (IShellOutputReceiver)multiLineReceiver);
        }
        catch (SDBNotExistException sDBNotExistException) {
            logger.info("SDBNotExistException: " + sDBNotExistException.getMessage());
            MessageBox.error((String)sDBNotExistException.getMessage());
            SDBHelperUtil.getInstance().closeMultiLineReceiver(multiLineReceiver);
            return bl;
        }
        catch (SDBCommandRejectedException sDBCommandRejectedException) {
            logger.info("SDBCommandRejectedException: " + sDBCommandRejectedException.getMessage());
            SDBHelperUtil.getInstance().closeMultiLineReceiver(multiLineReceiver);
            this.errorCheckVconf(ApplicationConstants.EMULATOR_NOT_READY);
            return bl;
        }
        catch (TimeoutException timeoutException) {
            logger.info("TimeoutException: " + timeoutException.getMessage());
            SDBHelperUtil.getInstance().closeMultiLineReceiver(multiLineReceiver);
            this.errorCheckVconf("SDB: " + timeoutException.getMessage());
            return bl;
        }
        catch (IOException iOException) {
            logger.info("IOException: " + iOException.getMessage());
            SDBHelperUtil.getInstance().closeMultiLineReceiver(multiLineReceiver);
            this.errorCheckVconf("SDB: " + iOException.getMessage());
            return bl;
        }
        logger.info("shellResult: " + this.shellResult);
        if (this.shellResult != null) {
            if (this.shellResult.indexOf("True") != -1 || this.shellResult.indexOf("1") != -1) {
                bl = true;
            } else {
                NFCDialog.openInfoDialog(NFCErrorString.NFCIsDisable);
            }
        }
        SDBHelperUtil.getInstance().closeMultiLineReceiver(multiLineReceiver);
        return bl;
    }

    public boolean sendMessage(int n, int n2, ArrayList<NDEFRecord> arrayList) {
        if (!this.checkVconfValue()) {
            return n != 100 && n != 102 && n != 104;
        }
        String string = null;
        switch (n) {
            case 100: {
                if (n2 != -1 && n2 != 0) {
                    String string2 = new String();
                    string2 = string2 + "," + arrayList.size();
                    for (NDEFRecord nDEFRecord : arrayList) {
                        string2 = string2 + "," + nDEFRecord.getFormat() + "," + nDEFRecord.getTypeName() + "," + nDEFRecord.getId() + "," + nDEFRecord.getPayload();
                    }
                    string = Integer.toString(100) + ":" + String.valueOf(n2) + string2 + "\n";
                    break;
                }
                NFCDialog.openErrorDialog(NFCErrorString.SelecTagType);
                return false;
            }
            case 101: {
                string = Integer.toString(101) + ":" + "\n";
                break;
            }
            case 102: {
                string = Integer.toString(102) + ":\n";
                break;
            }
            case 103: {
                string = Integer.toString(103) + ":\n";
                break;
            }
            case 104: {
                int n3 = 5;
                String string3 = new String();
                string3 = string3 + "," + arrayList.size();
                for (NDEFRecord nDEFRecord : arrayList) {
                    string3 = string3 + "," + nDEFRecord.getFormat() + "," + nDEFRecord.getTypeName() + "," + nDEFRecord.getId() + "," + nDEFRecord.getPayload();
                }
                string = Integer.toString(104) + ":" + String.valueOf(n3) + string3 + "\n";
                break;
            }
        }
        if (string != null) {
            this.send(string);
            return true;
        }
        return false;
    }

    public void send(String string) {
        MessageSender.getInstance().sendDeviceReq("nfc", 0, 0, string);
    }
}

