/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.nfc;

import com.google.protobuf.GeneratedMessage;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Logger;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;
import org.json.simple.JSONObject;
import org.tizen.ecp.nfc.NFCController;
import org.tizen.ecp.sock.EventMgr;
import org.tizen.ecp.sock.ILsn;
import org.tizen.ecp.sock.MessageSender;
import org.tizen.ecp.string.DeviceMessages;
import org.tizen.ecp.utils.ECPFXMLLoader;
import org.tizen.ecp.utils.JsonUtil;
import org.tizen.ecp.utils.LogUtil;
import org.tizen.ecp.views.popup.ECPPopupPane;

public class NFCPane
extends ECPPopupPane {
    static final URL NFC_CSS = NFCPane.class.getResource("nfc.css");
    private NFCController controller;
    private final String CMD_QTREE = DeviceMessages.getString("NFCDisplay.0");
    Logger logger = LogUtil.getECPLogger(NFCPane.class).getLogger();

    public void onCreate() {
        EventMgr.getInstance().AddLsn("nfc", (ILsn)this);
    }

    public void onShow() {
        MessageSender.getInstance().sendMonitorReq(this.createMsg());
        MessageSender.getInstance().sendDeviceReq("nfc", 15, 0);
    }

    private String createMsg() {
        String string = JsonUtil.encodeMonitorString((String)"execute", (String)"human-monitor-command", (String)"arguments", (JSONObject)JsonUtil.encodeObject((String)"command-line", (String)this.CMD_QTREE), (String)"nfc");
        return string;
    }

    public Pane create() {
        Pane pane = new Pane();
        try {
            URL uRL = ((Object)((Object)this)).getClass().getResource("nfcPopup.fxml");
            ECPFXMLLoader eCPFXMLLoader = new ECPFXMLLoader(uRL, new Object[0]);
            pane = (AnchorPane)eCPFXMLLoader.load();
            this.controller = (NFCController)eCPFXMLLoader.getController();
            pane.getStylesheets().add((Object)NFC_CSS.toExternalForm());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return pane;
    }

    public void OnEventProc(String string, JSONObject jSONObject) {
        this.controller.handleEventProc(string, jSONObject);
    }

    public void OnStatusEventProcPB(GeneratedMessage generatedMessage) {
        this.controller.handleStatusEventProcPB(generatedMessage);
    }
}

