/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.sensor;

import com.google.protobuf.GeneratedMessage;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.scene.Node;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import org.tizen.ecp.msg.genmsg.ecs.Ecs;
import org.tizen.ecp.sensor.accelerometer.AccelViewController;
import org.tizen.ecp.sensor.fxml.FXMLSensorViewController;
import org.tizen.ecp.sensor.geo.MagneticViewController;
import org.tizen.ecp.sensor.gui.FXMLSensorGuiController;
import org.tizen.ecp.sensor.gyro.GyroViewController;
import org.tizen.ecp.sock.EventMgr;
import org.tizen.ecp.sock.ILsn;
import org.tizen.ecp.sock.MessageSender;
import org.tizen.ecp.utils.ECPFXMLLoader;
import org.tizen.ecp.utils.LogUtil;
import org.tizen.ecp.views.popup.ECPPopupPane;

public class SensorPane
extends ECPPopupPane {
    private static Logger logger = LogUtil.getECPLogger(SensorPane.class).getLogger();
    private TabPane tabPane;
    private FXMLSensorViewController accelController;
    private FXMLSensorViewController geoController;
    private FXMLSensorViewController gyroController;

    public void onCreate() {
        EventMgr.getInstance().AddLsn("sensor", (ILsn)this);
    }

    public void onShow() {
        MessageSender.getInstance().sendDeviceReq("sensor", 15, 110);
        MessageSender.getInstance().sendDeviceReq("sensor", 15, 111);
        MessageSender.getInstance().sendDeviceReq("sensor", 15, 112);
    }

    public Pane create() {
        StackPane stackPane = new StackPane();
        this.tabPane = new TabPane();
        this.tabPane.setRotateGraphic(true);
        this.tabPane.setTabClosingPolicy(TabPane.TabClosingPolicy.UNAVAILABLE);
        this.tabPane.getStylesheets().add((Object)SensorPane.class.getResource("tab_view.css").toExternalForm());
        this.makeSensorTab();
        stackPane.getChildren().add((Object)this.tabPane);
        return stackPane;
    }

    private void makeSensorTab() {
        ECPFXMLLoader eCPFXMLLoader = new ECPFXMLLoader(SensorPane.class.getResource("fxml/sensor-gui.fxml"), FXMLSensorGuiController.class);
        Pane pane = null;
        try {
            pane = (Pane)eCPFXMLLoader.load();
        }
        catch (IOException iOException) {
            logger.log(Level.WARNING, "makeSensorTab IOException", iOException);
        }
        Tab tab = new Tab("GUI");
        if (pane != null) {
            tab.setContent((Node)pane);
        }
        this.tabPane.getTabs().add((Object)tab);
        this.accelController = this.makeSensorPane(new Tab("Acceleration"), AccelViewController.class);
        this.geoController = this.makeSensorPane(new Tab("Magnetic"), MagneticViewController.class);
        this.gyroController = this.makeSensorPane(new Tab("Gyro"), GyroViewController.class);
        this.tabPane.getSelectionModel().selectedIndexProperty().addListener((observableValue, number, number2) -> {
            if (number2.intValue() == 1) {
                MessageSender.getInstance().sendDeviceReq("sensor", 15, 110);
            } else if (number2.intValue() == 2) {
                MessageSender.getInstance().sendDeviceReq("sensor", 15, 112);
            } else if (number2.intValue() == 3) {
                MessageSender.getInstance().sendDeviceReq("sensor", 15, 111);
            }
        });
    }

    private FXMLSensorViewController makeSensorPane(Tab tab, Class<? extends FXMLSensorViewController> clazz) {
        ECPFXMLLoader eCPFXMLLoader = new ECPFXMLLoader(SensorPane.class.getResource("fxml/sensor.fxml"), clazz);
        Pane pane = null;
        try {
            pane = (Pane)eCPFXMLLoader.load();
            tab.setContent((Node)pane);
            this.tabPane.getTabs().add((Object)tab);
        }
        catch (IOException iOException) {
            logger.log(Level.WARNING, "makeSensorPane IOException", iOException);
        }
        return (FXMLSensorViewController)eCPFXMLLoader.getController();
    }

    public void OnStatusEventProcPB(GeneratedMessage generatedMessage) {
        if (!(generatedMessage instanceof Ecs.DeviceNtf)) {
            return;
        }
        Ecs.DeviceNtf deviceNtf = (Ecs.DeviceNtf)generatedMessage;
        long l = deviceNtf.getAction();
        if (110L == l) {
            this.accelController.setStatus(deviceNtf.getData().toStringUtf8());
        } else if (112L == l) {
            this.geoController.setStatus(deviceNtf.getData().toStringUtf8());
        } else if (111L == l) {
            this.gyroController.setStatus(deviceNtf.getData().toStringUtf8());
        } else {
            return;
        }
    }
}

