/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.battery;

import java.net.URL;
import java.util.ResourceBundle;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.TextField;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import org.tizen.ecp.legacy.InjectorMessage;
import org.tizen.ecp.resources.Images;
import org.tizen.ecp.sock.MessageSender;

public class BatteryController
implements Initializable {
    @FXML
    Label fx_connectStatus_lbl;
    @FXML
    Label fx_connect_lbl;
    @FXML
    ImageView fx_marker_img;
    @FXML
    ImageView fx_batteryBg_img;
    @FXML
    TextField fx_level_textfield;
    @FXML
    ProgressBar fx_batteryFg_prgsBar;
    ImageView on;
    ImageView off;
    double mouseX;
    double battery_bgX1;
    double battery_bgX2;
    double batteryBg_width;
    double marker_origX;

    @FXML
    public void onMouseClicked(MouseEvent mouseEvent) {
        if (this.fx_connect_lbl.getGraphic().getId() == "Off") {
            this.setCharge(true, true);
        } else {
            this.setCharge(false, true);
        }
    }

    @FXML
    public void onMouseDragged(MouseEvent mouseEvent) {
        double d = mouseEvent.getX();
        if (d >= 0.0 && d <= this.batteryBg_width) {
            this.changeLevel(mouseEvent.getX());
        }
    }

    @FXML
    public void onMousePressed(MouseEvent mouseEvent) {
        this.mouseX = mouseEvent.getScreenX();
        this.battery_bgX1 = this.fx_batteryBg_img.getX();
        this.battery_bgX2 = this.batteryBg_width + this.battery_bgX1;
    }

    @FXML
    public void onMouseReleased(MouseEvent mouseEvent) {
        this.changeLevel(mouseEvent.getX());
    }

    @FXML
    public void onProgrssBarClicked(MouseEvent mouseEvent) {
        this.changeLevel(mouseEvent.getX());
    }

    public void initialize(URL uRL, ResourceBundle resourceBundle) {
        this.on = Images.getImageView((String)"Battery", (String)"toggle_on.png");
        this.on.setId("On");
        this.off = Images.getImageView((String)"Battery", (String)"toggle_off.png");
        this.off.setId("Off");
        this.fx_connect_lbl.setGraphic((Node)this.off);
        this.batteryBg_width = this.fx_batteryBg_img.getFitWidth() - 3.0;
        this.marker_origX = this.fx_marker_img.getX();
    }

    @FXML
    public void onTextChanged(ActionEvent actionEvent) {
        String string = this.fx_level_textfield.getText();
        if (string.matches("\\d+")) {
            int n = Integer.valueOf(string);
            if (n >= 0 && n <= 100) {
                this.setLevel(n * 2, true);
            }
        } else {
            actionEvent.consume();
        }
    }

    public void setLevel(double d, boolean bl) {
        this.fx_batteryFg_prgsBar.setProgress(d / this.batteryBg_width + 0.03);
        int n = (int)(d / 2.0);
        this.fx_level_textfield.setText(String.valueOf(n));
        if (d >= 194.0) {
            this.fx_marker_img.setX(194.0);
        } else {
            this.fx_marker_img.setX(d + 1.0);
        }
        if (bl) {
            this.send(1, n);
        }
    }

    public void setCharge(boolean bl, boolean bl2) {
        if (bl) {
            this.fx_connectStatus_lbl.setText("Connect");
            this.fx_connect_lbl.setGraphic((Node)this.on);
        } else {
            this.fx_connectStatus_lbl.setText("Disonnect");
            this.fx_connect_lbl.setGraphic((Node)this.off);
        }
        if (bl2) {
            this.send(2, bl ? 1 : 0);
        }
    }

    public void changeLevel(double d) {
        if (d <= 0.0) {
            d = 0.0;
        } else if (d >= this.batteryBg_width) {
            d = this.batteryBg_width + 2.0;
        }
        this.setLevel(d, true);
    }

    public void send(int n, int n2) {
        InjectorMessage injectorMessage = new InjectorMessage(n, n2);
        MessageSender.getInstance().sendInjectorReq("sensor", 0, 100, "8\n" + injectorMessage.getMessage());
        MessageSender.getInstance().sendInjectorReq("sensor", 15, 100);
    }
}

