/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.earjack;

import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.GridPane;
import org.tizen.ecp.control.TizenRadioButton;
import org.tizen.ecp.earjack.EarJackModel;
import org.tizen.ecp.legacy.InjectorMessage;
import org.tizen.ecp.sock.MessageSender;

public class EarJackController
implements Initializable {
    @FXML
    public GridPane earjackGrid;
    private EarJackModel model;
    private TizenRadioButton threeWire;
    private TizenRadioButton fourWire;
    private TizenRadioButton disconnect;
    ChangeListener<Number> statusChangeListener = new ChangeListener<Number>(){

        public void changed(ObservableValue<? extends Number> observableValue, Number number, Number number2) {
            if (number2.intValue() == 1) {
                EarJackController.this.threeWire.setSelected(true);
            } else if (number2.intValue() == 3) {
                EarJackController.this.fourWire.setSelected(true);
            } else if (number2.intValue() == 0) {
                EarJackController.this.disconnect.setSelected(true);
            }
        }
    };
    ChangeListener<Toggle> toggleChangeListener = new ChangeListener<Toggle>(){

        public void changed(ObservableValue<? extends Toggle> observableValue, Toggle toggle, Toggle toggle2) {
            int n = -1;
            if (toggle == null) {
                return;
            }
            if (toggle2.equals(EarJackController.this.threeWire)) {
                n = 1;
            } else if (toggle2.equals(EarJackController.this.fourWire)) {
                n = 3;
            } else if (toggle2.equals(EarJackController.this.disconnect)) {
                n = 0;
            }
            EarJackController.this.model.setStatus(n);
            EarJackController.this.send(n);
        }
    };

    public EarJackController(EarJackModel earJackModel) {
        this.model = earJackModel;
    }

    public void initialize(URL uRL, ResourceBundle resourceBundle) {
        ToggleGroup toggleGroup = new ToggleGroup();
        toggleGroup.selectedToggleProperty().addListener(this.toggleChangeListener);
        this.threeWire = this.model.getThreeWire();
        this.threeWire.setHgap(18.0);
        this.threeWire.setToggleGroup(toggleGroup);
        this.earjackGrid.add((Node)this.threeWire, 1, 1, 3, 1);
        this.fourWire = this.model.getFourWire();
        this.fourWire.setHgap(18.0);
        this.fourWire.setToggleGroup(toggleGroup);
        this.earjackGrid.add((Node)this.fourWire, 1, 3, 3, 1);
        this.disconnect = this.model.getDisconnect();
        this.disconnect.setHgap(18.0);
        this.disconnect.setToggleGroup(toggleGroup);
        this.earjackGrid.add((Node)this.disconnect, 1, 5, 3, 1);
        this.model.getStatus().addListener(this.statusChangeListener);
    }

    public void send(int n) {
        InjectorMessage injectorMessage = new InjectorMessage(n);
        MessageSender.getInstance().sendInjectorReq("sensor", 0, 0, "9\n" + injectorMessage.getMessage());
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        MessageSender.getInstance().sendInjectorReq("sensor", 15, 103);
    }
}

