/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.location;

import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.scene.Parent;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import netscape.javascript.JSObject;
import org.tizen.ecp.connection.NetworkConnection;
import org.tizen.ecp.location.LocationConstants;
import org.tizen.ecp.location.LocationMapController;
import org.tizen.ecp.location.LocationPane;
import org.tizen.ecp.utils.LogUtil;

public class LocationMap
extends Parent {
    Logger logger = LogUtil.getECPLogger(LocationPane.class).getLogger();
    LocationMapController controller;
    private JSObject doc;
    private WebEngine webEngine;
    private boolean mapInitialized;

    public LocationMap(LocationMapController locationMapController, WebView webView) {
        this.controller = locationMapController;
        this.initMap(webView);
        this.initCommunication();
    }

    private void checkConnection() {
        String string = System.getProperty("java.net.useSystemProxies");
        this.logger.info("use system proxy: " + string);
        String string2 = System.getProperty("http.proxyHost");
        this.logger.info("host: " + string2);
        String string3 = System.getProperty("http.proxyPort");
        this.logger.info("port: " + string3);
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                final String string = NetworkConnection.check((String)LocationConstants.GOOGLE_MAP_URL);
                if (string != null) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            LocationMap.this.webEngine.loadContent(string);
                        }
                    });
                }
            }
        });
        thread.start();
    }

    private void initMap(WebView webView) {
        this.webEngine = webView.getEngine();
        this.checkConnection();
        this.mapInitialized = false;
        this.webEngine.getLoadWorker().stateProperty().addListener((ChangeListener)new ChangeListener<Worker.State>(){

            public void changed(ObservableValue<? extends Worker.State> observableValue, Worker.State state, Worker.State state2) {
                if (state2 == Worker.State.SUCCEEDED) {
                    LocationMap.this.mapInitialized = true;
                }
            }
        });
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                LocationMap.this.webEngine.load(this.getClass().getResource("resources/SimpleMap.html").toExternalForm());
            }
        });
    }

    private void initCommunication() {
        this.webEngine.getLoadWorker().stateProperty().addListener((ChangeListener)new ChangeListener<Worker.State>(){

            public void changed(ObservableValue<? extends Worker.State> observableValue, Worker.State state, Worker.State state2) {
                if (state2 == Worker.State.SUCCEEDED) {
                    LocationMap.this.doc = (JSObject)LocationMap.this.webEngine.executeScript("window");
                    LocationMap.this.doc.setMember("MapHandler", new MapHandler());
                    LocationMap.this.controller.mapView.setDisable(false);
                }
            }
        });
    }

    public void executeJS(final String string) {
        if (this.mapInitialized) {
            this.doc.eval(string);
        } else {
            this.webEngine.getLoadWorker().stateProperty().addListener((ChangeListener)new ChangeListener<Worker.State>(){

                public void changed(ObservableValue<? extends Worker.State> observableValue, Worker.State state, Worker.State state2) {
                    if (state2 == Worker.State.SUCCEEDED) {
                        LocationMap.this.doc.eval(string);
                    }
                }
            });
        }
    }

    public class MapHandler {
        public void setmark(double d, double d2) {
            LocationMap.this.controller.setMarkers(d, d2);
        }
    }
}

