/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.network;

import java.net.URL;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import org.json.simple.JSONObject;
import org.tizen.ecp.control.ButtonToggleEvent;
import org.tizen.ecp.control.TizenCheckBox;
import org.tizen.ecp.control.TizenRadioButton;
import org.tizen.ecp.control.TizenToggleButton;
import org.tizen.ecp.dialog.MessageBox;
import org.tizen.ecp.network.NetworkConstants;
import org.tizen.ecp.network.NetworkInfo;
import org.tizen.ecp.resources.Images;
import org.tizen.ecp.sock.MessageSender;
import org.tizen.ecp.utils.JsonUtil;

public class NetworkController
implements Initializable {
    @FXML
    GridPane fx_status_grid;
    @FXML
    Button fx_apply_btn;
    @FXML
    TextField fx_sPort_textfield;
    @FXML
    TextField fx_dPort_textfield;
    @FXML
    HBox fx_status_toggle;
    @FXML
    TableView<NetworkInfo> fx_networkList_table;
    @FXML
    Label fx_refresh_lbl;
    @FXML
    Label fx_sAddr_lbl;
    @FXML
    Label fx_dAddr_lbl;
    @FXML
    TableColumn<NetworkInfo, String> fx_interface_column;
    @FXML
    TableColumn<NetworkInfo, String> fx_protocol_column;
    @FXML
    TableColumn<NetworkInfo, String> fx_fd_column;
    @FXML
    TableColumn<NetworkInfo, String> fx_sAddr_column;
    @FXML
    TableColumn<NetworkInfo, String> fx_sPort_column;
    @FXML
    TableColumn<NetworkInfo, String> fx_dAddr_column;
    @FXML
    TableColumn<NetworkInfo, String> fx_dPort_column;
    @FXML
    TableColumn<NetworkInfo, String> fx_revQ_column;
    @FXML
    TableColumn<NetworkInfo, String> fx_sendQ_column;
    TizenCheckBox hidden_cb;
    @FXML
    Button fx_sendMsg_btn;
    @FXML
    Button fx_SMS_set_btn;
    @FXML
    Button fx_MMS_set_btn;
    TizenRadioButton tcp_radio;
    TizenRadioButton udp_radio;
    TizenToggleButton status_toggle;
    ToggleGroup typeGroup;
    ImageView refresh_nor;
    ImageView refresh_over;
    ImageView refresh_sel;
    ObservableList<NetworkInfo> networkList = FXCollections.observableArrayList();

    public void initialize(URL uRL, ResourceBundle resourceBundle) {
        this.fx_interface_column.setCellValueFactory(cellDataFeatures -> ((NetworkInfo)cellDataFeatures.getValue()).getIface());
        this.fx_protocol_column.setCellValueFactory(cellDataFeatures -> ((NetworkInfo)cellDataFeatures.getValue()).getProtocol());
        this.fx_fd_column.setCellValueFactory(cellDataFeatures -> ((NetworkInfo)cellDataFeatures.getValue()).getFd());
        this.fx_sAddr_column.setCellValueFactory(cellDataFeatures -> ((NetworkInfo)cellDataFeatures.getValue()).getsAddress());
        this.fx_sPort_column.setCellValueFactory(cellDataFeatures -> ((NetworkInfo)cellDataFeatures.getValue()).getsPort());
        this.fx_dAddr_column.setCellValueFactory(cellDataFeatures -> ((NetworkInfo)cellDataFeatures.getValue()).getdAddress());
        this.fx_dPort_column.setCellValueFactory(cellDataFeatures -> ((NetworkInfo)cellDataFeatures.getValue()).getdPort());
        this.fx_revQ_column.setCellValueFactory(cellDataFeatures -> ((NetworkInfo)cellDataFeatures.getValue()).getRevQ());
        this.fx_sendQ_column.setCellValueFactory(cellDataFeatures -> ((NetworkInfo)cellDataFeatures.getValue()).getSendQ());
        this.status_toggle = new TizenToggleButton("Connect", "Disconnect");
        this.status_toggle.setOn(true);
        this.fx_status_toggle.getChildren().add((Object)this.status_toggle);
        this.status_toggle.setOnSelected((EventHandler)new EventHandler<ButtonToggleEvent>(){

            public void handle(ButtonToggleEvent buttonToggleEvent) {
                if (buttonToggleEvent.isSelected()) {
                    if (NetworkController.this.status_toggle.getOn()) {
                        MessageSender.getInstance().sendMonitorReq(NetworkController.this.createNetworkConnectMsg("set_link virtio-net-pci.0 on"));
                    } else {
                        MessageSender.getInstance().sendMonitorReq(NetworkController.this.createNetworkConnectMsg("set_link virtio-net-pci.0 off"));
                    }
                }
            }
        });
        this.typeGroup = new ToggleGroup();
        this.tcp_radio = new TizenRadioButton("TCP");
        this.tcp_radio.setToggleGroup(this.typeGroup);
        this.tcp_radio.setUserData((Object)"tcp");
        this.fx_status_grid.add((Node)this.tcp_radio, 0, 0);
        this.udp_radio = new TizenRadioButton("UDP");
        this.udp_radio.setToggleGroup(this.typeGroup);
        this.udp_radio.setUserData((Object)"udp");
        this.fx_status_grid.add((Node)this.udp_radio, 1, 0);
        this.typeGroup.selectToggle((Toggle)this.tcp_radio);
        this.refresh_nor = Images.getImageView((String)"Network", (String)"platform_refresh_nor.png");
        this.refresh_over = Images.getImageView((String)"Network", (String)"platform_refresh_over.png");
        this.refresh_sel = Images.getImageView((String)"Network", (String)"platform_refresh_sel.png");
        this.fx_refresh_lbl.setGraphic((Node)this.refresh_nor);
    }

    @FXML
    public void onApplyAction(ActionEvent actionEvent) {
        String string = this.checkPorts(NetworkConstants.PORT_TYPE.SOURCE_PORT);
        if (string == "-1") {
            return;
        }
        String string2 = this.checkPorts(NetworkConstants.PORT_TYPE.DESTINATION_PORT);
        if (string2 == "-1") {
            return;
        }
        String string3 = this.typeGroup.getSelectedToggle().getUserData().toString() + ":" + string + ":" + this.fx_dAddr_lbl.getText() + ":" + string2;
        MessageSender.getInstance().sendDeviceReq("Network", 0, 0, string3);
        MessageSender.getInstance().sendMonitorReq(this.createUsernetMsg());
    }

    private String checkPorts(NetworkConstants.PORT_TYPE pORT_TYPE) {
        String string = null;
        if (pORT_TYPE == NetworkConstants.PORT_TYPE.SOURCE_PORT) {
            string = this.fx_sPort_textfield.getText();
        } else if (pORT_TYPE == NetworkConstants.PORT_TYPE.DESTINATION_PORT) {
            string = this.fx_dPort_textfield.getText();
        }
        if (string.equals("")) {
            MessageBox.error((String)"Please fill in the port number.");
            string = "-1";
        } else if (!string.matches("(6553[0-5]|655[0-2]\\d|65[0-4]\\d{2}|6[0-4]\\d{3}|[1-5]\\d{4}|[1-9]\\d{0,3})")) {
            MessageBox.error((String)"Please input a valid port number[0 - 65535].");
            string = "-1";
        }
        return string;
    }

    public String createUsernetMsg() {
        String string = JsonUtil.encodeMonitorString((String)"execute", (String)"human-monitor-command", (String)"arguments", (JSONObject)JsonUtil.encodeObject((String)"command-line", (String)"info usernet"), (String)"Network");
        return string;
    }

    private String createNetworkConnectMsg(String string) {
        String string2 = JsonUtil.encodeMonitorString((String)"execute", (String)"human-monitor-command", (String)"arguments", (JSONObject)JsonUtil.encodeObject((String)"command-line", (String)string), (String)"Network");
        return string2;
    }

    public void setNetworkInfo(String string) {
        this.parseNetworkMsg(string);
    }

    private void parseNetworkMsg(String string) {
        String[] stringArray = string.split("\r\n");
        String string2 = null;
        this.clearNetworkInfo();
        for (String string3 : stringArray) {
            if (string3.length() < 72) continue;
            if (string3.startsWith("VLAN")) {
                string2 = string3.substring(0, string3.length() - 1);
                continue;
            }
            if ((string3 = string3.substring(2, string3.length())).startsWith("Protocol[State]")) continue;
            NetworkInfo networkInfo = new NetworkInfo(string2 == null ? "" : string2, string3.substring(0, 18).trim(), string3.substring(18, 22).trim(), string3.substring(22, 38).trim(), string3.substring(38, 44).trim(), string3.substring(44, 60).trim(), string3.substring(60, 66).trim(), string3.substring(66, 72).trim(), string3.substring(72, string3.length()).trim());
            this.networkList.add((Object)networkInfo);
        }
        this.fx_networkList_table.setItems(this.networkList);
    }

    @FXML
    public void onRefreshPressed(MouseEvent mouseEvent) {
        this.fx_refresh_lbl.setGraphic((Node)this.refresh_sel);
        MessageSender.getInstance().sendMonitorReq(this.createUsernetMsg());
    }

    @FXML
    public void onRefreshMoved(MouseEvent mouseEvent) {
        this.fx_refresh_lbl.setGraphic((Node)this.refresh_over);
    }

    @FXML
    public void onRefreshExited(MouseEvent mouseEvent) {
        this.fx_refresh_lbl.setGraphic((Node)this.refresh_nor);
    }

    @FXML
    public void onRefreshReleased() {
        this.fx_refresh_lbl.setGraphic((Node)this.refresh_over);
    }

    public void setProtocol(String string) {
        if (string.equals("Connect")) {
            this.status_toggle.setOn(true);
        } else {
            this.status_toggle.setOn(false);
        }
    }

    public void clearNetworkInfo() {
        this.networkList.clear();
    }
}

