/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.battery;

import com.google.protobuf.GeneratedMessage;
import java.io.IOException;
import java.net.URL;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;
import org.tizen.ecp.battery.BatteryController;
import org.tizen.ecp.msg.genmsg.ecs.Ecs;
import org.tizen.ecp.sock.EventMgr;
import org.tizen.ecp.sock.ILsn;
import org.tizen.ecp.sock.MessageSender;
import org.tizen.ecp.utils.ECPFXMLLoader;
import org.tizen.ecp.views.popup.ECPPopupPane;

public class BatteryPane
extends ECPPopupPane {
    public static final URL BATTERY_CSS = BatteryPane.class.getResource("Battery.css");
    BatteryController batteryController;

    public void onCreate() {
        EventMgr.getInstance().AddLsn("sensor", (ILsn)this);
        MessageSender.getInstance().sendInjectorReq("sensor", 15, 100);
        MessageSender.getInstance().sendInjectorReq("sensor", 15, 101);
    }

    public void onShow() {
        MessageSender.getInstance().sendInjectorReq("sensor", 15, 100);
        MessageSender.getInstance().sendInjectorReq("sensor", 15, 101);
    }

    public Pane create() {
        AnchorPane anchorPane;
        try {
            URL uRL = ((Object)((Object)this)).getClass().getResource("BatteryPopup.fxml");
            ECPFXMLLoader eCPFXMLLoader = new ECPFXMLLoader(uRL, new Object[0]);
            anchorPane = (AnchorPane)eCPFXMLLoader.load();
            anchorPane.getStylesheets().add((Object)BATTERY_CSS.toExternalForm());
            this.batteryController = (BatteryController)eCPFXMLLoader.getController();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        return anchorPane;
    }

    public void OnStatusEventProcPB(GeneratedMessage generatedMessage) {
        if (generatedMessage instanceof Ecs.InjectorNtf) {
            Ecs.InjectorNtf injectorNtf = (Ecs.InjectorNtf)generatedMessage;
            long l = injectorNtf.getAction();
            if (100L == l) {
                String string = injectorNtf.getData().toStringUtf8();
                this.setCardDescription(string + " %");
                if (this.batteryController != null) {
                    this.batteryController.setLevel(Double.valueOf(string) * 2.0, false);
                }
            } else if (101L == l) {
                String string = injectorNtf.getData().toStringUtf8();
                if (this.batteryController != null) {
                    this.batteryController.setCharge(string.equals("1"), false);
                }
            }
        }
    }
}

