/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.hds;

import com.google.protobuf.GeneratedMessage;
import java.util.logging.Logger;
import org.kohsuke.args4j.Argument;
import org.tizen.cli.AbstractEmulatorCLI;
import org.tizen.cli.utils.OutputUtil;
import org.tizen.ecp.msg.genmsg.ecs.Ecs;
import org.tizen.ecp.sock.MessageSender;
import org.tizen.ecp.string.DeviceMessages;
import org.tizen.ecp.utils.LogUtil;

public class HDSStatusCLI
extends AbstractEmulatorCLI {
    private static Logger logger = LogUtil.getECPLogger(HDSStatusCLI.class).getLogger();
    @Argument(index=0, required=false)
    String hidden;

    public HDSStatusCLI() {
        this.messageType = "hds";
    }

    public int execute() {
        MessageSender.getInstance().sendDeviceReq(this.messageType, 15, 99);
        this.startRunning();
        return 0;
    }

    public void OnStatusEventProcPB(GeneratedMessage generatedMessage) {
        Ecs.DeviceNtf deviceNtf;
        if (generatedMessage instanceof Ecs.DeviceNtf && 99 == (deviceNtf = (Ecs.DeviceNtf)generatedMessage).getAction()) {
            String string = new String(deviceNtf.getData().toByteArray());
            logger.info("HDS status is " + string);
            if (string == null || string.isEmpty()) {
                OutputUtil.println((String)DeviceMessages.getString("HDSStatusCLI.3"));
                this.stopRunning();
                return;
            }
            String[] stringArray = string.split("\n");
            if (stringArray[0] == null || stringArray[0].length() < 4) {
                OutputUtil.println((String)DeviceMessages.getString("HDSStatusCLI.3"));
                this.stopRunning();
                return;
            }
            OutputUtil.println((String)DeviceMessages.getString("HDSStatusCLI.6"));
            for (String string2 : stringArray) {
                String string3 = "";
                String[] stringArray2 = string2.split(",");
                if (stringArray2.length < 4) continue;
                if (this.hidden != null && "hidden".equals(this.hidden)) {
                    if ("1".equals(stringArray2[3])) {
                        string3 = " (hidden)";
                    }
                } else if ("1".equals(stringArray2[3])) continue;
                OutputUtil.println((String)(DeviceMessages.getString("HDSStatusCLI.8") + stringArray2[0] + DeviceMessages.getString("HDSStatusCLI.9") + stringArray2[1] + DeviceMessages.getString("HDSStatusCLI.10") + stringArray2[2] + string3));
            }
            this.stopRunning();
        }
    }
}

