/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.location;

import java.net.URL;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.TimerTask;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.web.WebView;
import javafx.util.Callback;
import org.tizen.ecp.location.LocationCommonControl;
import org.tizen.ecp.location.LocationInjector;
import org.tizen.ecp.location.LocationMap;
import org.tizen.ecp.location.model.GeoLocation;
import org.tizen.ecp.location.model.GeoLocationVO;
import org.tizen.ecp.location.model.LocationData;

public class LocationMapController
extends LocationCommonControl {
    @FXML
    WebView mapView;
    @FXML
    TableView<LocationData> mapTable;
    @FXML
    Button buttonInjectLocation;
    @FXML
    Button buttonResetMapMarkers;
    @FXML
    Button buttonCancelMap;
    LocationMap map;
    @FXML
    TableColumn<LocationData, Integer> seqColumn;
    @FXML
    TableColumn<LocationData, String> latColumn;
    @FXML
    TableColumn<LocationData, String> lngColumn;
    int seq = 0;
    private InjectTask task = null;
    private LocationInjector injector = null;
    private ArrayList<GeoLocationVO> locationVO = new ArrayList();
    private final ObservableList<LocationData> data = FXCollections.observableArrayList();

    private boolean validate() {
        return this.locationVO.size() != 0;
    }

    public void setMarkers(double d, double d2) {
        String string = String.format("%.6f", d);
        String string2 = String.format("%.6f", d2);
        GeoLocationVO geoLocationVO = new GeoLocationVO();
        this.data.add((Object)new LocationData(++this.seq, string, string2));
        GeoLocation geoLocation = new GeoLocation(string, string2);
        geoLocationVO.setSeq(this.seq);
        geoLocationVO.setLocation(geoLocation);
        this.locationVO.add(geoLocationVO);
        boolean bl = this.validate();
        this.buttonInjectLocation.setDisable(!bl);
        this.buttonResetMapMarkers.setDisable(!bl);
    }

    @FXML
    public void OnclickInjectLocation(ActionEvent actionEvent) {
        this.task = new InjectTask();
        this.startTask(this.task);
        this.buttonInjectLocation.setDisable(true);
        this.mapView.setDisable(true);
        this.buttonCancelMap.setDisable(false);
        this.buttonResetMapMarkers.setDisable(true);
    }

    @FXML
    public void OnClickResetMapMarkers(ActionEvent actionEvent) {
        this.map.executeJS("deleteMarkers()");
        this.mapTable.getItems().clear();
        this.locationVO.clear();
        boolean bl = this.validate();
        this.buttonInjectLocation.setDisable(!bl);
        this.buttonResetMapMarkers.setDisable(!bl);
    }

    @FXML
    public void OnClickCancelMap(ActionEvent actionEvent) {
        this.stopTask();
        this.buttonInjectLocation.setDisable(false);
        this.mapView.setDisable(false);
        this.buttonCancelMap.setDisable(true);
        this.buttonResetMapMarkers.setDisable(false);
    }

    public void initialize(URL uRL, ResourceBundle resourceBundle) {
        this.mapTable.setItems(this.data);
        this.buttonCancelMap.setDisable(true);
        this.buttonInjectLocation.setDisable(true);
        this.buttonResetMapMarkers.setDisable(true);
        this.seqColumn.setCellValueFactory((Callback)new PropertyValueFactory("seq"));
        this.latColumn.setCellValueFactory((Callback)new PropertyValueFactory("latitude"));
        this.lngColumn.setCellValueFactory((Callback)new PropertyValueFactory("longitude"));
        this.mapView.setDisable(true);
        this.map = new LocationMap(this, this.mapView);
    }

    class InjectTask
    extends TimerTask {
        InjectTask() {
        }

        @Override
        public void run() {
            LocationMapController.this.injector = new LocationInjector();
            if (!LocationMapController.this.injector.inject(LocationMapController.this.locationVO)) {
                LocationMapController.this.stopTask();
            }
        }
    }
}

