/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.nfc;

import org.tizen.ecp.nfc.FileListingService;

public class FileTreeData {
    private TreeItemState treeItemState = TreeItemState.CHILD_NOT_CHECKED;
    private final FileListingService.FileEntry entry;

    public FileTreeData() {
        this(null);
    }

    public FileTreeData(FileListingService.FileEntry fileEntry) {
        this.entry = fileEntry;
    }

    public boolean isDirectory() {
        if (this.entry == null) {
            return false;
        }
        return this.entry.getType() == 1 || this.entry.getType() == 2;
    }

    public String getFileName() {
        return this.entry.getName();
    }

    public int getFileType() {
        return this.entry.getType();
    }

    public FileListingService.FileEntry getFileEntry() {
        return this.entry;
    }

    public String getFullPath() {
        return this.entry.getFullPath();
    }

    public void setTreeItemState(TreeItemState treeItemState) {
        this.treeItemState = treeItemState;
    }

    public boolean isChildChecking() {
        return this.treeItemState == TreeItemState.CHILD_CHECKING;
    }

    public boolean isChildChecked() {
        return this.treeItemState == TreeItemState.CHILD_CHECKED;
    }

    static enum TreeItemState {
        CHILD_NOT_CHECKED,
        CHILD_CHECKING,
        CHILD_CHECKED;

    }
}

