/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.rssi;

import com.google.protobuf.GeneratedMessage;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Logger;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;
import org.tizen.ecp.msg.genmsg.ecs.Ecs;
import org.tizen.ecp.rssi.RSSIController;
import org.tizen.ecp.sock.EventMgr;
import org.tizen.ecp.sock.ILsn;
import org.tizen.ecp.sock.MessageSender;
import org.tizen.ecp.utils.ECPFXMLLoader;
import org.tizen.ecp.utils.LogUtil;
import org.tizen.ecp.views.popup.ECPPopupPane;

public class RSSIPane
extends ECPPopupPane {
    RSSIController controller;
    Logger logger = LogUtil.getECPLogger(RSSIPane.class).getLogger();

    public void onCreate() {
        EventMgr.getInstance().AddLsn("sensor", (ILsn)this);
        MessageSender.getInstance().sendInjectorReq("sensor", 15, 104);
    }

    public void onShow() {
        MessageSender.getInstance().sendInjectorReq("sensor", 15, 104);
    }

    public void onClose() {
        MessageSender.getInstance().sendInjectorReq("sensor", 15, 104);
        super.onClose();
    }

    public Pane create() {
        AnchorPane anchorPane;
        try {
            URL uRL = ((Object)((Object)this)).getClass().getResource("RSSI.fxml");
            ECPFXMLLoader eCPFXMLLoader = new ECPFXMLLoader(uRL, new Object[0]);
            anchorPane = (AnchorPane)eCPFXMLLoader.load();
            this.controller = (RSSIController)eCPFXMLLoader.getController();
        }
        catch (IOException iOException) {
            this.logger.warning(iOException.getMessage());
            return null;
        }
        return anchorPane;
    }

    public void OnStatusEventProcPB(GeneratedMessage generatedMessage) {
        String string;
        if (!(generatedMessage instanceof Ecs.InjectorNtf)) {
            return;
        }
        Ecs.InjectorNtf injectorNtf = (Ecs.InjectorNtf)generatedMessage;
        if (104 == injectorNtf.getAction() && (string = injectorNtf.getData().toStringUtf8()) != null && !string.isEmpty()) {
            int n;
            if (this.controller != null) {
                this.controller.setLevel(string);
            }
            if ((n = Integer.valueOf(string).intValue()) == 0) {
                this.setCardDescription("No Signal");
            } else if (n <= 2) {
                this.setCardDescription("Normal");
            } else if (n <= 4) {
                this.setCardDescription("Good");
            }
        }
    }
}

