/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.location;

import com.google.protobuf.GeneratedMessage;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Logger;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import org.tizen.ecp.location.LocationCommonControl;
import org.tizen.ecp.location.LocationConstants;
import org.tizen.ecp.location.LocationEventMode;
import org.tizen.ecp.location.LocationLogController;
import org.tizen.ecp.location.LocationManualController;
import org.tizen.ecp.location.LocationMapController;
import org.tizen.ecp.msg.genmsg.ecs.Ecs;
import org.tizen.ecp.sock.EventMgr;
import org.tizen.ecp.sock.ILsn;
import org.tizen.ecp.sock.MessageSender;
import org.tizen.ecp.utils.ECPFXMLLoader;
import org.tizen.ecp.utils.LogUtil;
import org.tizen.ecp.views.popup.ECPPopupPane;

public class LocationPane
extends ECPPopupPane {
    Logger logger = LogUtil.getECPLogger(LocationPane.class).getLogger();
    Image cardImage;
    ImageView cardView;
    LocationMapController mapController;
    LocationManualController manualController;
    LocationLogController logController;
    ScrollPane scrollPane;
    VBox root;
    int index = 0;

    public void onShow() {
        EventMgr.getInstance().AddLsn("sensor", (ILsn)this);
        this.sendStatus();
    }

    public void sendStatus() {
        MessageSender.getInstance().sendInjectorReq("sensor", 15, 120);
    }

    public Pane create() {
        AnchorPane anchorPane = new AnchorPane();
        this.scrollPane = new ScrollPane();
        this.scrollPane.setFitToWidth(true);
        this.scrollPane.setVbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        this.scrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        this.scrollPane.setPrefHeight(380.0);
        this.root = new VBox();
        this.mapController = (LocationMapController)this.getController("resources/LocationMapPopup.fxml", LocationMapController.class);
        this.manualController = (LocationManualController)this.getController("resources/LocationManualPopup.fxml", LocationManualController.class);
        this.logController = (LocationLogController)this.getController("resources/LocationLogPopup.fxml", LocationLogController.class);
        this.scrollPane.setContent((Node)this.root);
        anchorPane.getChildren().addAll((Object[])new Node[]{this.scrollPane});
        AnchorPane.setBottomAnchor((Node)this.scrollPane, (Double)0.0);
        AnchorPane.setLeftAnchor((Node)this.scrollPane, (Double)0.0);
        AnchorPane.setRightAnchor((Node)this.scrollPane, (Double)0.0);
        AnchorPane.setTopAnchor((Node)this.scrollPane, (Double)0.0);
        return anchorPane;
    }

    private LocationCommonControl getController(String string, Class<? extends LocationCommonControl> clazz) {
        URL uRL = ((Object)((Object)this)).getClass().getResource(string);
        ECPFXMLLoader eCPFXMLLoader = new ECPFXMLLoader(uRL, new Object[0]);
        try {
            AnchorPane anchorPane = (AnchorPane)eCPFXMLLoader.load();
            this.root.getChildren().add((Object)anchorPane);
        }
        catch (IOException iOException) {
            this.logger.warning(iOException.getMessage());
        }
        return (LocationCommonControl)eCPFXMLLoader.getController();
    }

    public void OnStatusEventProcPB(GeneratedMessage generatedMessage) {
        if (!(generatedMessage instanceof Ecs.InjectorNtf)) {
            return;
        }
        Ecs.InjectorNtf injectorNtf = (Ecs.InjectorNtf)generatedMessage;
        long l = injectorNtf.getAction();
        if (120L != l) {
            this.logger.info("action value is skipped: " + l);
            return;
        }
        String string = injectorNtf.getData().toStringUtf8();
        Enum enum_ = null;
        if (string == null) {
            this.logger.severe(LocationConstants.FailedGetValue);
            return;
        }
        String[] stringArray = string.split(",");
        for (LocationEventMode locationEventMode : LocationEventMode.values()) {
            if (!locationEventMode.toString().equals(stringArray[0])) continue;
            enum_ = locationEventMode;
            break;
        }
        if (enum_ == null) {
            this.logger.warning("cannot get mode.");
            return;
        }
        switch (1.$SwitchMap$org$tizen$ecp$location$LocationEventMode[enum_.ordinal()]) {
            case 1: {
                this.logger.info("STOPMODE");
                this.manualController.setLocation(null, null, null, null);
                break;
            }
            case 2: {
                this.logger.info("LOGMODE");
                this.manualController.setLocation(null, null, null, null);
                break;
            }
            case 3: {
                this.logger.info("MANUALMODE");
                this.manualController.setLocation(stringArray[1], stringArray[2], stringArray[3], stringArray[4]);
                break;
            }
        }
    }
}

