/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.memory;

import com.google.protobuf.GeneratedMessage;
import org.kohsuke.args4j.Argument;
import org.tizen.cli.AbstractEmulatorCLI;
import org.tizen.cli.utils.OutputUtil;
import org.tizen.ecp.msg.genmsg.ecs.Ecs;
import org.tizen.ecp.sock.MessageSender;
import org.tizen.ecp.string.DeviceMessages;

public class LowMemorySetCLI
extends AbstractEmulatorCLI {
    private String TYPE_VCONF;
    @Argument(required=true, metaVar="soft-warning hard-warning normal")
    String mode;

    public LowMemorySetCLI() {
        this.messageType = this.TYPE_VCONF = DeviceMessages.getString("LowMemorySetCLI.0");
    }

    public void printHelp() {
        OutputUtil.print((String)this.help);
    }

    public int execute() {
        int n = 0;
        if (this.mode == null) {
            OutputUtil.printError((String)DeviceMessages.getString("LowMemorySetCLI.1"));
            this.printHelp();
            return 25;
        }
        if (this.mode.toLowerCase().equals(DeviceMessages.getString("LowMemorySetCLI.2"))) {
            n = 2;
        } else if (this.mode.toLowerCase().equals(DeviceMessages.getString("LowMemorySetCLI.3"))) {
            n = 4;
        } else if (this.mode.toLowerCase().equals(DeviceMessages.getString("LowMemorySetCLI.4"))) {
            n = 1;
        } else {
            OutputUtil.printError((String)("'" + this.mode + DeviceMessages.getString("LowMemorySetCLI.6")));
            OutputUtil.println((String)this.help);
            return 25;
        }
        MessageSender.getInstance().sendInjectorReq("vconf", 30, 1, "int\nmemory/sysman/low_memory\n" + n + "\n");
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            OutputUtil.printError((String)DeviceMessages.getString("LowMemorySetCLI.8"), (Exception)interruptedException);
        }
        MessageSender.getInstance().sendInjectorReq("vconf", 30, 0, "int\nmemory/sysman/low_memory\n\n");
        this.startRunning();
        if (this.returnValue == 128) {
            OutputUtil.printFail();
        } else {
            OutputUtil.printOK();
        }
        return 0;
    }

    public void OnEventProcPB(String string, GeneratedMessage generatedMessage) {
        if (generatedMessage instanceof Ecs.InjectorAns) {
            Ecs.InjectorAns injectorAns = (Ecs.InjectorAns)generatedMessage;
            int n = injectorAns.getErrcode();
            if (n != 0) {
                this.returnValue = 128;
            }
            this.stopRunning();
        }
    }
}

