/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.sensor.fxml;

import java.io.File;
import java.util.ArrayList;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Skin;
import javafx.scene.control.Slider;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import javafx.stage.FileChooser;
import javafx.util.Callback;
import org.tizen.ecp.control.TizenSliderSkin;
import org.tizen.ecp.control.TizenTextField;
import org.tizen.ecp.dialog.MessageBox;
import org.tizen.ecp.resources.Images;
import org.tizen.ecp.sensor.SensorFileEvent;
import org.tizen.ecp.sensor.SensorFileOperation;
import org.tizen.ecp.sensor.fxml.LogFileData;

public abstract class FXMLSensorViewController
implements Initializable {
    @FXML
    protected Label fxNameLab;
    @FXML
    protected GridPane fxXGrid;
    @FXML
    protected GridPane fxYGrid;
    @FXML
    protected GridPane fxZGrid;
    protected TizenTextField fxXTxt;
    protected TizenTextField fxYTxt;
    protected TizenTextField fxZTxt;
    @FXML
    protected Slider fxXSlider;
    @FXML
    protected Label fxXUnitLab;
    @FXML
    protected Slider fxYSlider;
    @FXML
    protected Label fxYUnitLab;
    @FXML
    protected Slider fxZSlider;
    @FXML
    protected Label fxZUnitLab;
    @FXML
    protected TextField fxLogPathTxt;
    @FXML
    protected Button fxBrowseBtn;
    @FXML
    protected Button fxAddBtn;
    @FXML
    protected Button fxStartBtn;
    @FXML
    protected Button fxStopBtn;
    @FXML
    protected Button fxDeleteBtn;
    @FXML
    protected TableView<LogFileData> fxLogTable;
    @FXML
    protected TableColumn<LogFileData, Integer> fxNumber;
    @FXML
    protected TableColumn<LogFileData, String> fxFilePath;
    @FXML
    private ObservableList<LogFileData> fileItems;
    private FileChooser fileChooser;
    protected File selectedFile;
    private SensorFileOperation fileOperation;
    private ChangeListener<Number> sliderValueListener = new ChangeListener<Number>(){

        public void changed(ObservableValue<? extends Number> observableValue, Number number, Number number2) {
            FXMLSensorViewController.this.sendMessage();
        }
    };
    private EventHandler<SensorFileEvent> fileFinisedHandler = new EventHandler<SensorFileEvent>(){

        public void handle(SensorFileEvent sensorFileEvent) {
            FXMLSensorViewController.this.onClickStopButton(null);
        }
    };
    private ListChangeListener<Integer> changeListener = new ListChangeListener<Integer>(){

        public void onChanged(ListChangeListener.Change<? extends Integer> change) {
            ObservableList observableList = FXMLSensorViewController.this.fxLogTable.getSelectionModel().getSelectedItems();
            if (observableList.size() == 1 && !FXMLSensorViewController.this.fxStartBtn.isDisable()) {
                FXMLSensorViewController.this.fxDeleteBtn.setDisable(false);
            } else {
                FXMLSensorViewController.this.fxDeleteBtn.setDisable(true);
            }
        }
    };

    protected void initialize() {
        this.makeTextButton();
        this.fxXSlider.setSkin((Skin)new TizenSliderSkin(this.fxXSlider));
        this.fxYSlider.setSkin((Skin)new TizenSliderSkin(this.fxYSlider));
        this.fxZSlider.setSkin((Skin)new TizenSliderSkin(this.fxZSlider));
        this.fxXSlider.valueProperty().addListener(this.sliderValueListener);
        this.fxYSlider.valueProperty().addListener(this.sliderValueListener);
        this.fxZSlider.valueProperty().addListener(this.sliderValueListener);
        ImageView imageView = Images.getImageView((String)"Common", (String)"btn_ic_path.png");
        if (imageView != null) {
            this.fxBrowseBtn.setText("");
            this.fxBrowseBtn.setGraphic((Node)imageView);
        } else {
            this.fxBrowseBtn.setText("...");
        }
        ImageView imageView2 = Images.getImageView((String)"Common", (String)"btn_ic_add.png");
        if (imageView2 != null) {
            this.fxAddBtn.setText("");
            this.fxAddBtn.setGraphic((Node)imageView2);
        } else {
            this.fxAddBtn.setText("A");
        }
        this.fxAddBtn.setDisable(true);
        this.fxStartBtn.setDisable(true);
        this.fxStopBtn.setDisable(true);
        this.fxDeleteBtn.setDisable(true);
        this.fileItems = this.fxLogTable.getItems();
        this.fxLogTable.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.fxLogTable.getSelectionModel().getSelectedIndices().addListener(this.changeListener);
        this.fxNumber.setCellValueFactory((Callback)new PropertyValueFactory("number"));
        this.fxFilePath.setCellValueFactory((Callback)new PropertyValueFactory("path"));
        this.fxFilePath.getStyleClass().add((Object)"file-column");
        this.fxFilePath.setId("file-column");
    }

    private void makeTextButton() {
        this.fxXTxt = new TizenTextField();
        this.fxYTxt = new TizenTextField();
        this.fxZTxt = new TizenTextField();
        this.fxXGrid.add((Node)this.fxXTxt, 2, 0);
        this.fxYGrid.add((Node)this.fxYTxt, 2, 0);
        this.fxZGrid.add((Node)this.fxZTxt, 2, 0);
        GridPane.setMargin((Node)this.fxXTxt, (Insets)new Insets(0.0, 5.0, 0.0, 8.0));
        GridPane.setMargin((Node)this.fxYTxt, (Insets)new Insets(0.0, 5.0, 0.0, 8.0));
        GridPane.setMargin((Node)this.fxZTxt, (Insets)new Insets(0.0, 5.0, 0.0, 8.0));
        this.fxXTxt.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                FXMLSensorViewController.this.onEnterToTextField(FXMLSensorViewController.this.fxXTxt, FXMLSensorViewController.this.fxXSlider);
            }
        });
        this.fxYTxt.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                FXMLSensorViewController.this.onEnterToTextField(FXMLSensorViewController.this.fxYTxt, FXMLSensorViewController.this.fxYSlider);
            }
        });
        this.fxZTxt.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                FXMLSensorViewController.this.onEnterToTextField(FXMLSensorViewController.this.fxZTxt, FXMLSensorViewController.this.fxZSlider);
            }
        });
    }

    public SensorFileOperation getFileOperation() {
        return this.fileOperation;
    }

    public void setFileOperation(SensorFileOperation sensorFileOperation) {
        if (this.fileOperation != null) {
            sensorFileOperation.removeSensorFileListener(this.fileFinisedHandler);
        }
        this.fileOperation = sensorFileOperation;
        sensorFileOperation.addSenorFileListener(this.fileFinisedHandler);
    }

    protected abstract void onEnterToTextField(TizenTextField var1, Slider var2);

    public abstract void sendMessage();

    public abstract void setStatus(String var1);

    @FXML
    public void onClickBrowseButton(ActionEvent actionEvent) {
        if (this.fileChooser == null) {
            ArrayList<FileChooser.ExtensionFilter> arrayList = new ArrayList<FileChooser.ExtensionFilter>();
            arrayList.add(new FileChooser.ExtensionFilter("Sensor log Files (*.txt, *.log", new String[]{"*.txt", "*.log"}));
            arrayList.add(new FileChooser.ExtensionFilter("All files", new String[]{"*"}));
            this.fileChooser = new FileChooser();
            this.fileChooser.getExtensionFilters().clear();
            this.fileChooser.getExtensionFilters().addAll(arrayList);
            this.fileChooser.setTitle("Select log file");
        }
        this.selectedFile = this.fileChooser.showOpenDialog(null);
        if (this.selectedFile != null) {
            this.fxLogPathTxt.setText(this.selectedFile.getAbsolutePath());
            this.fxAddBtn.setDisable(false);
        }
    }

    @FXML
    public void onClickAddButton(ActionEvent actionEvent) {
        if (this.selectedFile == null) {
            return;
        }
        if (this.fileItems.size() == 5) {
            MessageBox.error((String)"Emulator Control Panel", (String)"The maximum number of files is 5");
            return;
        }
        LogFileData logFileData = new LogFileData(this.fileItems.size() + 1, this.selectedFile);
        this.fileItems.add((Object)logFileData);
        this.fxStartBtn.setDisable(false);
    }

    @FXML
    public void onClickStartButton(ActionEvent actionEvent) {
        if (this.fileOperation == null) {
            return;
        }
        this.fxStartBtn.setDisable(true);
        this.fxDeleteBtn.setDisable(true);
        this.fxAddBtn.setDisable(true);
        for (LogFileData logFileData : this.fileItems) {
            this.fileOperation.addFile(logFileData.getLogFile());
        }
        this.fileOperation.startInjection();
        this.fxStopBtn.setDisable(false);
    }

    @FXML
    public void onClickStopButton(ActionEvent actionEvent) {
        if (this.fileOperation == null) {
            return;
        }
        if (!this.fileOperation.isFinished()) {
            this.fileOperation.stopInjection();
        }
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                FXMLSensorViewController.this.fxStartBtn.setDisable(false);
                FXMLSensorViewController.this.fxStopBtn.setDisable(true);
                if (FXMLSensorViewController.this.fxLogTable.getSelectionModel().getSelectedIndex() >= 0) {
                    FXMLSensorViewController.this.fxDeleteBtn.setDisable(false);
                }
                if (FXMLSensorViewController.this.selectedFile != null) {
                    FXMLSensorViewController.this.fxAddBtn.setDisable(false);
                }
            }
        });
    }

    @FXML
    public void onClickDeleteButton(ActionEvent actionEvent) {
        ObservableList observableList = this.fxLogTable.getSelectionModel().getSelectedItems();
        for (LogFileData logFileData : observableList) {
            this.fileItems.remove((Object)logFileData);
            this.reorderTable();
        }
        if (this.fileItems.size() == 0) {
            this.fxStartBtn.setDisable(true);
            this.fxStopBtn.setDisable(true);
            this.fxDeleteBtn.setDisable(true);
        }
    }

    private void reorderTable() {
        int n = 1;
        for (LogFileData logFileData : this.fileItems) {
            logFileData.setNumber(n++);
        }
    }
}

