/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.sensor.proximity;

import com.google.protobuf.GeneratedMessage;
import org.kohsuke.args4j.Argument;
import org.tizen.cli.AbstractEmulatorCLI;
import org.tizen.cli.CLIConstants;
import org.tizen.cli.utils.OutputUtil;
import org.tizen.ecp.legacy.InjectorMessage;
import org.tizen.ecp.msg.genmsg.ecs.Ecs;
import org.tizen.ecp.sock.MessageSender;
import org.tizen.ecp.string.DeviceMessages;

public class SensorProxiCLI
extends AbstractEmulatorCLI {
    private String TYPE_SENSOR;
    @Argument(required=true, index=0)
    String onOff;

    public SensorProxiCLI() {
        this.messageType = this.TYPE_SENSOR = "sensor";
    }

    public int execute() {
        int n;
        if (this.onOff.trim().toLowerCase().equals("on")) {
            n = 0;
        } else if (this.onOff.trim().toLowerCase().equals("off")) {
            n = 8;
        } else {
            OutputUtil.printError((String)CLIConstants.ERR_DESC_NO_PROPER_ARGS);
            this.printHelp();
            return 25;
        }
        InjectorMessage injectorMessage = new InjectorMessage(n);
        MessageSender.getInstance().sendDeviceReq("sensor", 0, 0, "2\n" + injectorMessage.getMessage());
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            OutputUtil.printError((String)DeviceMessages.getString("SensorProxiCLI.3"), (Exception)interruptedException);
        }
        MessageSender.getInstance().sendDeviceReq("sensor", 15, 114);
        this.startRunning();
        if (this.returnValue == 128) {
            OutputUtil.printFail();
        } else {
            OutputUtil.printOK();
        }
        return 0;
    }

    public void OnEventProcPB(String string, GeneratedMessage generatedMessage) {
        if (generatedMessage instanceof Ecs.DeviceAns) {
            Ecs.DeviceAns deviceAns = (Ecs.DeviceAns)generatedMessage;
            int n = deviceAns.getErrcode();
            if (n != 0) {
                this.returnValue = 128;
            }
            this.stopRunning();
        }
    }
}

